/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TestUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.net.InetAddress;
import java.util.concurrent.ThreadFactory;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(createCluster={false})
public class NettyOptionsTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_invoke_netty_options_hooks_single_node() throws Exception {
        this.should_invoke_netty_options_hooks(1, 1);
    }

    @CCMConfig(numberOfNodes={3})
    @Test(groups={"short"})
    public void should_invoke_netty_options_hooks_multi_node() throws Exception {
        this.should_invoke_netty_options_hooks(3, 4);
    }

    private void should_invoke_netty_options_hooks(int hosts, int coreConnections) throws Exception {
        NettyOptions nettyOptions = (NettyOptions)Mockito.mock(NettyOptions.class, (Answer)Answers.CALLS_REAL_METHODS.get());
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        HashedWheelTimer timer = new HashedWheelTimer();
        ((NettyOptions)Mockito.doReturn((Object)eventLoopGroup).when((Object)nettyOptions)).eventLoopGroup((ThreadFactory)Matchers.any(ThreadFactory.class));
        ((NettyOptions)Mockito.doReturn((Object)timer).when((Object)nettyOptions)).timer((ThreadFactory)Matchers.any(ThreadFactory.class));
        final ChannelHandler handler = (ChannelHandler)Mockito.mock(ChannelHandler.class);
        ((NettyOptions)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                SocketChannel channel = (SocketChannel)invocation.getArguments()[0];
                channel.pipeline().addLast("test-handler", handler);
                return null;
            }
        }).when((Object)nettyOptions)).afterChannelInitialized((SocketChannel)Matchers.any(SocketChannel.class));
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withPoolingOptions(new PoolingOptions().setConnectionsPerHost(HostDistance.LOCAL, coreConnections, coreConnections)).withNettyOptions(nettyOptions).build());
        cluster.connect();
        int expectedNumberOfCalls = TestUtils.numberOfLocalCoreConnections(cluster) * hosts + 1;
        ProtocolVersion version = ProtocolVersion.NEWEST_SUPPORTED;
        ProtocolVersion usedVersion = this.ccm().getProtocolVersion();
        while (version != usedVersion && version != null) {
            version = version.getLowerSupported();
            ++expectedNumberOfCalls;
        }
        cluster.close();
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)1))).eventLoopGroup((ThreadFactory)Matchers.any(ThreadFactory.class));
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)1))).channelClass();
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)1))).timer((ThreadFactory)Matchers.any(ThreadFactory.class));
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)expectedNumberOfCalls))).afterBootstrapInitialized((Bootstrap)Matchers.any(Bootstrap.class));
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)expectedNumberOfCalls))).afterChannelInitialized((SocketChannel)Matchers.any(SocketChannel.class));
        ((ChannelHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)expectedNumberOfCalls))).handlerAdded((ChannelHandlerContext)Matchers.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)expectedNumberOfCalls))).handlerRemoved((ChannelHandlerContext)Matchers.any(ChannelHandlerContext.class));
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)1))).onClusterClose((EventLoopGroup)eventLoopGroup);
        ((NettyOptions)Mockito.verify((Object)nettyOptions, (VerificationMode)Mockito.times((int)1))).onClusterClose((Timer)timer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{nettyOptions});
    }
}

