/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ColumnMetadataAssert;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.MaterializedViewMetadataAssert;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TableMetadataAssert;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.annotations.Test;

@CassandraVersion(value="3.0")
public class MaterializedViewMetadataTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_create_view_metadata() {
        String createTable = String.format("CREATE TABLE %s.scores(user TEXT,game TEXT,year INT,month INT,day INT,score INT,PRIMARY KEY (user, game, year, month, day))", this.keyspace);
        String createMV = String.format("CREATE MATERIALIZED VIEW %s.monthlyhigh AS SELECT game, year, month, score, user, day FROM %s.scores WHERE game IS NOT NULL AND year IS NOT NULL AND month IS NOT NULL AND score IS NOT NULL AND user IS NOT NULL AND day IS NOT NULL PRIMARY KEY ((game, year, month), score, user, day) WITH CLUSTERING ORDER BY (score DESC, user ASC, day ASC)", this.keyspace, this.keyspace);
        this.session().execute(createTable);
        this.session().execute(createMV);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("scores");
        MaterializedViewMetadata mv = this.cluster().getMetadata().getKeyspace(this.keyspace).getMaterializedView("monthlyhigh");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("scores").hasMaterializedView(mv).hasNumberOfColumns(6);
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("user").isPartitionKey();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("game").isClusteringColumn();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("year").isClusteringColumn();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(3)).isNotNull()).hasName("month").isClusteringColumn();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(4)).isNotNull()).hasName("day").isClusteringColumn();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(5)).isNotNull()).hasName("score").isRegularColumn();
        ((MaterializedViewMetadataAssert)Assertions.assertThat(mv).isNotNull()).hasName("monthlyhigh").hasBaseTable(table).hasNumberOfColumns(6).isEqualTo(table.getView("monthlyhigh"));
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(0)).isNotNull()).hasName("game").isPartitionKey();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(1)).isNotNull()).hasName("year").isPartitionKey();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(2)).isNotNull()).hasName("month").isPartitionKey();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(3)).isNotNull()).hasName("score").isClusteringColumn().hasClusteringOrder(ClusteringOrder.DESC);
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(4)).isNotNull()).hasName("user").isClusteringColumn();
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(5)).isNotNull()).hasName("day").isClusteringColumn();
        Assertions.assertThat((String)mv.asCQLQuery(false)).contains(new CharSequence[]{createMV});
    }

    @Test(groups={"short"})
    public void should_create_view_metadata_with_quoted_identifiers() {
        String createTable = String.format("CREATE TABLE %s.\"T1\" (\"theKey\" int, \"the;Clustering\" int, \"the Value\" int, PRIMARY KEY (\"theKey\", \"the;Clustering\"))", this.keyspace);
        String createMV = String.format("CREATE MATERIALIZED VIEW %s.\"Mv1\" AS SELECT \"theKey\", \"the;Clustering\", \"the Value\" FROM %s.\"T1\" WHERE \"theKey\" IS NOT NULL AND \"the;Clustering\" IS NOT NULL AND \"the Value\" IS NOT NULL PRIMARY KEY (\"theKey\", \"the;Clustering\")", this.keyspace, this.keyspace);
        this.session().execute(createTable);
        this.session().execute(createMV);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("\"T1\"");
        MaterializedViewMetadata mv = this.cluster().getMetadata().getKeyspace(this.keyspace).getMaterializedView("\"Mv1\"");
        ((TableMetadataAssert)Assertions.assertThat(table).isNotNull()).hasName("T1").hasMaterializedView(mv).hasNumberOfColumns(3);
        Assertions.assertThat((Iterable)table.getViews()).hasSize(1).containsOnly((Object[])new MaterializedViewMetadata[]{mv});
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(0)).isNotNull()).hasName("theKey").isPartitionKey().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(1)).isNotNull()).hasName("the;Clustering").isClusteringColumn().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)table.getColumns().get(2)).isNotNull()).hasName("the Value").isRegularColumn().hasType(DataType.cint());
        ((MaterializedViewMetadataAssert)Assertions.assertThat(mv).isNotNull()).hasName("Mv1").hasBaseTable(table).hasNumberOfColumns(3);
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(0)).isNotNull()).hasName("theKey").isPartitionKey().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(1)).isNotNull()).hasName("the;Clustering").isClusteringColumn().hasType(DataType.cint());
        ((ColumnMetadataAssert)Assertions.assertThat((ColumnMetadata)mv.getColumns().get(2)).isNotNull()).hasName("the Value").isRegularColumn().hasType(DataType.cint());
        Assertions.assertThat((String)mv.asCQLQuery(false)).contains(new CharSequence[]{createMV});
    }
}

