/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataTypeClassNameParserTest {
    private ProtocolVersion protocolVersion = ProtocolVersion.NEWEST_SUPPORTED;
    private CodecRegistry codecRegistry = new CodecRegistry();

    @Test(groups={"unit"})
    public void parseOneTest() {
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.ByteType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.tinyint());
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.ShortType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.smallint());
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.SimpleDateType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.date());
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.TimeType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.time());
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.InetAddressType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.inet());
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.ListType(org.apache.cassandra.db.marshal.UTF8Type)", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.list((DataType)DataType.text()));
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)"org.apache.cassandra.db.marshal.ReversedType(org.apache.cassandra.db.marshal.UTF8Type)", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.text());
        String s = "org.apache.cassandra.db.marshal.CompositeType(org.apache.cassandra.db.marshal.UTF8Type, org.apache.cassandra.db.marshal.Int32Type)";
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.custom((String)s));
        s = "org.apache.cassandra.db.marshal.ReversedType(org.apache.cassandra.db.marshal.ListType(org.apache.cassandra.db.marshal.Int32Type))";
        Assert.assertEquals((Object)DataTypeClassNameParser.parseOne((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry), (Object)DataType.list((DataType)DataType.cint()));
    }

    @Test(groups={"unit"})
    public void parseWithCompositeTest() {
        String s = "org.apache.cassandra.db.marshal.CompositeType(org.apache.cassandra.db.marshal.Int32Type, org.apache.cassandra.db.marshal.UTF8Type,";
        s = s + "org.apache.cassandra.db.marshal.ColumnToCollectionType(6162:org.apache.cassandra.db.marshal.ListType(org.apache.cassandra.db.marshal.Int32Type)))";
        DataTypeClassNameParser.ParseResult r1 = DataTypeClassNameParser.parseWithComposite((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
        Assert.assertTrue((boolean)r1.isComposite);
        Assert.assertEquals((Collection)r1.types, Arrays.asList(DataType.cint(), DataType.text()));
        Assert.assertEquals((int)r1.collections.size(), (int)1);
        Assert.assertEquals(r1.collections.get("ab"), (Object)DataType.list((DataType)DataType.cint()));
        DataTypeClassNameParser.ParseResult r2 = DataTypeClassNameParser.parseWithComposite((String)"org.apache.cassandra.db.marshal.TimestampType", (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
        Assert.assertFalse((boolean)r2.isComposite);
        Assert.assertEquals((Collection)r2.types, Arrays.asList(DataType.timestamp()));
        Assert.assertEquals((int)r2.collections.size(), (int)0);
    }

    @Test(groups={"unit"})
    public void parseUserTypes() {
        String s = "org.apache.cassandra.db.marshal.UserType(foo,61646472657373,737472656574:org.apache.cassandra.db.marshal.UTF8Type,7a6970636f6465:org.apache.cassandra.db.marshal.Int32Type,70686f6e6573:org.apache.cassandra.db.marshal.SetType(org.apache.cassandra.db.marshal.UserType(foo,70686f6e65,6e616d65:org.apache.cassandra.db.marshal.UTF8Type,6e756d626572:org.apache.cassandra.db.marshal.UTF8Type)))";
        UserType def = (UserType)DataTypeClassNameParser.parseOne((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
        Assert.assertEquals((String)def.getKeyspace(), (String)"foo");
        Assert.assertEquals((String)def.getTypeName(), (String)"address");
        Iterator iter = def.iterator();
        UserType.Field field1 = (UserType.Field)iter.next();
        Assert.assertEquals((String)field1.getName(), (String)"street");
        Assert.assertEquals((Object)field1.getType(), (Object)DataType.text());
        UserType.Field field2 = (UserType.Field)iter.next();
        Assert.assertEquals((String)field2.getName(), (String)"zipcode");
        Assert.assertEquals((Object)field2.getType(), (Object)DataType.cint());
        UserType.Field field3 = (UserType.Field)iter.next();
        Assert.assertEquals((String)field3.getName(), (String)"phones");
        DataType st = field3.getType();
        Assert.assertEquals((Object)st.getName(), (Object)DataType.Name.SET);
        UserType subDef = (UserType)st.getTypeArguments().get(0);
        Assert.assertEquals((String)subDef.getKeyspace(), (String)"foo");
        Assert.assertEquals((String)subDef.getTypeName(), (String)"phone");
        Iterator subIter = subDef.iterator();
        UserType.Field subField1 = (UserType.Field)subIter.next();
        Assert.assertEquals((String)subField1.getName(), (String)"name");
        Assert.assertEquals((Object)subField1.getType(), (Object)DataType.text());
        UserType.Field subField2 = (UserType.Field)subIter.next();
        Assert.assertEquals((String)subField2.getName(), (String)"number");
        Assert.assertEquals((Object)subField2.getType(), (Object)DataType.text());
    }

    @Test(groups={"unit"})
    public void parseTupleTest() {
        String s = "org.apache.cassandra.db.marshal.TupleType(org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.FloatType)";
        TupleType type = (TupleType)DataTypeClassNameParser.parseOne((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(type.getComponentTypes().get(0), (Object)DataType.cint());
        Assert.assertEquals(type.getComponentTypes().get(1), (Object)DataType.text());
        Assert.assertEquals(type.getComponentTypes().get(2), (Object)DataType.cfloat());
    }

    @Test(groups={"unit"})
    public void parseNestedCollectionTest() {
        String s = "org.apache.cassandra.db.marshal.MapType(org.apache.cassandra.db.marshal.UTF8Type,org.apache.cassandra.db.marshal.FrozenType(org.apache.cassandra.db.marshal.MapType(org.apache.cassandra.db.marshal.Int32Type,org.apache.cassandra.db.marshal.Int32Type)))";
        DataType parentMap = DataTypeClassNameParser.parseOne((String)s, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
        Assertions.assertThat(parentMap).hasName(DataType.Name.MAP).isNotFrozen().hasTypeArgument(0, DataType.text());
        DataType childMap = (DataType)parentMap.getTypeArguments().get(1);
        Assertions.assertThat(childMap).hasName(DataType.Name.MAP).isFrozen().hasTypeArguments(DataType.cint(), DataType.cint());
    }
}

