/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CassandraVersion(value="2.2.0")
@CCMConfig(jvmArgs={"-Dcassandra.custom_query_handler_class=org.apache.cassandra.cql3.CustomPayloadMirroringQueryHandler"})
public class CustomPayloadTest
extends CCMTestsSupport {
    private Map<String, ByteBuffer> payload1;
    private Map<String, ByteBuffer> payload2;

    @BeforeMethod(groups={"short", "unit"})
    public void initPayloads() {
        this.payload1 = ImmutableMap.of((Object)"k1", (Object)ByteBuffer.wrap(new byte[]{1, 2, 3}), (Object)"k2", (Object)ByteBuffer.wrap(new byte[]{4, 5, 6}));
        this.payload2 = ImmutableMap.of((Object)"k2", (Object)ByteBuffer.wrap(new byte[]{1, 2}), (Object)"k3", (Object)ByteBuffer.wrap(new byte[]{3, 4}));
    }

    @Test(groups={"short"})
    public void should_echo_custom_payload_when_executing_statement() throws Exception {
        SimpleStatement statement = new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1});
        statement.setOutgoingPayload(this.payload1);
        ResultSet rows = this.session().execute((Statement)statement);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
    }

    @Test(groups={"short"})
    public void should_echo_custom_payload_when_executing_batch_statement() throws Exception {
        BatchStatement statement = new BatchStatement().add((Statement)new SimpleStatement("INSERT INTO t1 (c1, c2) values (1, 'foo')"));
        statement.setOutgoingPayload(this.payload1);
        ResultSet rows = this.session().execute((Statement)statement);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
    }

    @Test(groups={"short"})
    public void should_echo_custom_payload_when_building_statement() throws Exception {
        Statement statement = QueryBuilder.select((String[])new String[]{"c2"}).from("t1").where(QueryBuilder.eq((String)"c1", (Object)1)).setOutgoingPayload(this.payload1);
        ResultSet rows = this.session().execute(statement);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
    }

    @Test(groups={"short"})
    public void should_propagate_incoming_payload_to_bound_statement() throws Exception {
        SimpleStatement statement = new SimpleStatement("SELECT c2 as col1 FROM t1 where c1 = ?");
        statement.setOutgoingPayload(this.payload1);
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        Assertions.assertThat((Map)ps.getOutgoingPayload()).isEqualTo(this.payload1);
        Assertions.assertThat((Map)ps.getIncomingPayload()).isEqualTo(this.payload1);
        ps.setOutgoingPayload(null);
        BoundStatement bs = ps.bind(new Object[]{1});
        ResultSet rows = this.session().execute((Statement)bs);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
        bs = ps.bind();
        bs.setInt(0, 1);
        rows = this.session().execute((Statement)bs);
        actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
    }

    @Test(groups={"short"})
    public void should_override_incoming_payload_when_outgoing_payload_explicitly_set_on_preparing_statement() throws Exception {
        SimpleStatement statement = new SimpleStatement("SELECT c2 as col2 FROM t1 where c1 = ?");
        statement.setOutgoingPayload(this.payload1);
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        Assertions.assertThat((Map)ps.getOutgoingPayload()).isEqualTo(this.payload1);
        Assertions.assertThat((Map)ps.getIncomingPayload()).isEqualTo(this.payload1);
        ps.setOutgoingPayload(this.payload2);
        BoundStatement bs = ps.bind(new Object[]{1});
        ResultSet rows = this.session().execute((Statement)bs);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload2);
        bs = ps.bind();
        bs.setInt(0, 1);
        rows = this.session().execute((Statement)bs);
        actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload2);
    }

    @Test(groups={"short"})
    public void should_not_set_any_payload_on_bound_statement() throws Exception {
        SimpleStatement statement = new SimpleStatement("SELECT c2 as col3 FROM t1 where c1 = ?");
        PreparedStatement ps = this.session().prepare((RegularStatement)statement);
        Assertions.assertThat((Map)ps.getOutgoingPayload()).isNull();
        Assertions.assertThat((Map)ps.getIncomingPayload()).isNull();
        BoundStatement bs = ps.bind(new Object[]{1});
        Assertions.assertThat((Map)bs.getOutgoingPayload()).isNull();
        bs.setOutgoingPayload(this.payload1);
        ResultSet rows = this.session().execute((Statement)bs);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(this.payload1);
        bs = ps.bind();
        Assertions.assertThat((Map)bs.getOutgoingPayload()).isNull();
        bs.setInt(0, 1);
        rows = this.session().execute((Statement)bs);
        actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isNull();
    }

    @Test(groups={"short"})
    public void should_echo_custom_payload_when_paginating() throws Exception {
        this.session().execute("INSERT INTO t1 (c1, c2) VALUES (1, 'a')");
        this.session().execute("INSERT INTO t1 (c1, c2) VALUES (1, 'b')");
        SimpleStatement statement = new SimpleStatement("SELECT c2 FROM t1 where c1 = 1");
        statement.setFetchSize(1);
        statement.setOutgoingPayload(this.payload1);
        ResultSet rows = this.session().execute((Statement)statement);
        rows.all();
        Assertions.assertThat((List)rows.getAllExecutionInfo()).extracting("incomingPayload").containsOnly(new Object[]{this.payload1});
    }

    @Test(groups={"short"})
    public void should_encode_null_values() throws Exception {
        HashMap<String, ByteBuffer> payload = new HashMap<String, ByteBuffer>();
        payload.put("k1", Statement.NULL_PAYLOAD_VALUE);
        SimpleStatement statement = new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1});
        statement.setOutgoingPayload(payload);
        ResultSet rows = this.session().execute((Statement)statement);
        Map actual = rows.getExecutionInfo().getIncomingPayload();
        Assertions.assertThat((Map)actual).isEqualTo(payload);
    }

    @Test(groups={"unit"}, expectedExceptions={NullPointerException.class})
    public void should_throw_npe_when_null_key_on_regular_statement() throws Exception {
        HashMap<Object, ByteBuffer> payload = new HashMap<Object, ByteBuffer>();
        payload.put(null, ByteBuffer.wrap(new byte[]{1}));
        new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1}).setOutgoingPayload(payload);
    }

    @Test(groups={"unit"}, expectedExceptions={NullPointerException.class})
    public void should_throw_npe_when_null_value_on_regular_statement() throws Exception {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("k1", null);
        new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1}).setOutgoingPayload(payload);
    }

    @Test(groups={"short"}, expectedExceptions={NullPointerException.class})
    public void should_throw_npe_when_null_key_on_prepared_statement() throws Exception {
        HashMap<Object, ByteBuffer> payload = new HashMap<Object, ByteBuffer>();
        payload.put(null, ByteBuffer.wrap(new byte[]{1}));
        this.session().prepare((RegularStatement)new SimpleStatement("SELECT c2 FROM t1 where c1 = 1")).setOutgoingPayload(payload);
    }

    @Test(groups={"short"}, expectedExceptions={NullPointerException.class})
    public void should_throw_npe_when_null_value_on_prepared_statement() throws Exception {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("k1", null);
        this.session().prepare((RegularStatement)new SimpleStatement("SELECT c2 FROM t1 where c1 = 2")).setOutgoingPayload(payload);
    }

    @Test(groups={"short"})
    public void should_throw_ufe_when_protocol_version_lesser_than_4() throws Exception {
        try {
            Cluster v3cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(ProtocolVersion.V3).build()).init();
            Session v3session = v3cluster.connect();
            SimpleStatement statement = new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1});
            statement.setOutgoingPayload(this.payload1);
            v3session.execute((Statement)statement);
            Fail.fail((String)"Should not send custom payloads with protocol V3");
        }
        catch (UnsupportedFeatureException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Unsupported feature with the native protocol V3 (which is currently in use): Custom payloads are only supported since native protocol V4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_print_log_message_when_level_trace() throws Exception {
        Logger logger = Logger.getLogger((String)Message.logger.getName());
        MemoryAppender appender = new MemoryAppender();
        try {
            logger.setLevel(Level.TRACE);
            logger.addAppender((Appender)appender);
            SimpleStatement statement = new SimpleStatement("SELECT c2 FROM t1 where c1 = ?", new Object[]{1});
            statement.setOutgoingPayload(this.payload1);
            this.session().execute((Statement)statement);
            String logs = appender.waitAndGet(10000L);
            Assertions.assertThat((String)logs).contains(new CharSequence[]{"Sending payload: {k1:0x010203, k2:0x040506} (24 bytes total)"}).contains(new CharSequence[]{"Received payload: {k1:0x010203, k2:0x040506} (24 bytes total)"});
        }
        finally {
            logger.setLevel(null);
            logger.removeAppender((Appender)appender);
        }
    }

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE t1 (c1 int, c2 text,  PRIMARY KEY (c1, c2))");
    }
}

