/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingReconnectionPolicy
implements ReconnectionPolicy {
    public final AtomicInteger count = new AtomicInteger();
    private final ReconnectionPolicy childPolicy;

    public CountingReconnectionPolicy(ReconnectionPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public ReconnectionPolicy.ReconnectionSchedule newSchedule() {
        return new CountingSchedule(this.childPolicy.newSchedule());
    }

    public void init(Cluster cluster) {
    }

    public void close() {
        this.childPolicy.close();
    }

    class CountingSchedule
    implements ReconnectionPolicy.ReconnectionSchedule {
        private final ReconnectionPolicy.ReconnectionSchedule childSchedule;

        public CountingSchedule(ReconnectionPolicy.ReconnectionSchedule childSchedule) {
            this.childSchedule = childSchedule;
        }

        public long nextDelayMs() {
            CountingReconnectionPolicy.this.count.incrementAndGet();
            return this.childSchedule.nextDelayMs();
        }
    }
}

