/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.CassandraVersion;
import com.datastax.driver.core.utils.DseVersion;
import java.util.List;
import org.testng.SkipException;
import org.testng.annotations.Test;

@CassandraVersion(value="2.2.0")
@CCMConfig(config={"enable_user_defined_functions:true"})
public class AggregateMetadataTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_and_format_aggregate_with_initcond_and_no_finalfunc() {
        String cqlFunction = String.format("CREATE FUNCTION %s.cat(s text,v int) RETURNS NULL ON NULL INPUT RETURNS text LANGUAGE java AS 'return s+v;';", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.cat_tos(int) SFUNC cat STYPE text INITCOND '0';", this.keyspace);
        this.session().execute(cqlFunction);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction("cat", new DataType[]{DataType.text(), DataType.cint()});
        AggregateMetadata aggregate = keyspace.getAggregate("cat_tos", new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"cat_tos(int)");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"cat_tos");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).containsExactly((Object[])new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isEqualTo((Object)"0");
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(DataType.text());
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(DataType.text());
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
        Assertions.assertThat((String)aggregate.exportAsString()).isEqualTo((Object)String.format("CREATE AGGREGATE %s.cat_tos(int)\n    SFUNC cat\n    STYPE text\n    INITCOND '0';", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_aggregate_with_no_arguments() {
        String cqlFunction = String.format("CREATE FUNCTION %s.inc(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i+1;';", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.mycount() SFUNC inc STYPE int INITCOND 0;", this.keyspace);
        this.session().execute(cqlFunction);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction("inc", new DataType[]{DataType.cint()});
        AggregateMetadata aggregate = keyspace.getAggregate("mycount", new DataType[0]);
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"mycount()");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"mycount");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).isEmpty();
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isEqualTo((Object)0);
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(DataType.cint());
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
        Assertions.assertThat((String)aggregate.exportAsString()).isEqualTo((Object)String.format("CREATE AGGREGATE %s.mycount()\n    SFUNC inc\n    STYPE int\n    INITCOND 0;", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_aggregate_with_final_function() {
        String cqlFunction1 = String.format("CREATE FUNCTION %s.plus(i int, j int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i+j;';", this.keyspace);
        String cqlFunction2 = String.format("CREATE FUNCTION %s.announce(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i;';", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.prettysum(int) SFUNC plus STYPE int FINALFUNC announce INITCOND 0;", this.keyspace);
        this.session().execute(cqlFunction1);
        this.session().execute(cqlFunction2);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction("plus", new DataType[]{DataType.cint(), DataType.cint()});
        FunctionMetadata finalFunc = keyspace.getFunction("announce", new DataType[]{DataType.cint()});
        AggregateMetadata aggregate = keyspace.getAggregate("prettysum", new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"prettysum(int)");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"prettysum");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).containsExactly((Object[])new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate.getFinalFunc()).isEqualTo(finalFunc);
        Assertions.assertThat((Object)aggregate.getInitCond()).isEqualTo((Object)0);
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(DataType.cint());
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
        Assertions.assertThat((String)aggregate.exportAsString()).isEqualTo((Object)String.format("CREATE AGGREGATE %s.prettysum(int)\n    SFUNC plus\n    STYPE int\n    FINALFUNC announce\n    INITCOND 0;", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_aggregate_with_no_initcond() {
        String cqlFunction = String.format("CREATE FUNCTION %s.plus2(i int, j int) CALLED ON NULL INPUT RETURNS int LANGUAGE java AS 'return i+j;';", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.sum(int) SFUNC plus2 STYPE int;", this.keyspace);
        this.session().execute(cqlFunction);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction("plus2", new DataType[]{DataType.cint(), DataType.cint()});
        AggregateMetadata aggregate = keyspace.getAggregate("sum", new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"sum(int)");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"sum");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).containsExactly((Object[])new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isNull();
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(DataType.cint());
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
        Assertions.assertThat((String)aggregate.exportAsString()).isEqualTo((Object)String.format("CREATE AGGREGATE %s.sum(int)\n    SFUNC plus2\n    STYPE int;", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_aggregate_with_udts() {
        String cqlFunction = String.format("CREATE FUNCTION %s.\"MY_FUNC\"(address1 \"Address\", address2 \"Address\") CALLED ON NULL INPUT RETURNS \"Address\" LANGUAGE java AS 'return address1;'", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.\"MY_AGGREGATE\"(\"Address\") SFUNC \"MY_FUNC\" STYPE \"Address\";", this.keyspace);
        this.session().execute(cqlFunction);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        UserType addressType = keyspace.getUserType("\"Address\"");
        FunctionMetadata stateFunc = keyspace.getFunction("\"MY_FUNC\"", new DataType[]{addressType, addressType});
        AggregateMetadata aggregate = keyspace.getAggregate("\"MY_AGGREGATE\"", new DataType[]{addressType});
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"\"MY_AGGREGATE\"(\"Address\")");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"MY_AGGREGATE");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).containsExactly((Object[])new DataType[]{addressType});
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isNull();
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(addressType);
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(addressType);
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_parse_and_format_aggregate_with_composite_type_literal_initcond() {
        VersionNumber ver = this.ccm().getCassandraVersion();
        if (ver.getMajor() == 3 && (ver.getMinor() >= 1 && ver.getMinor() < 4 || ver.getMinor() == 0 && ver.getPatch() < 4)) {
            throw new SkipException("Requires C* 2.2.X, 3.0.4+ or 3.4.X+");
        }
        this.parse_and_format_aggregate_with_composite_type("ag0", "'s@foo:i@32'");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.4")
    public void should_parse_and_format_aggregate_with_composite_type_hex_initcond() {
        VersionNumber ver = this.ccm().getCassandraVersion();
        if (ver.getMinor() >= 1 && ver.getMinor() < 4) {
            throw new SkipException("Requires 3.0.4+ or 3.4.X+");
        }
        this.parse_and_format_aggregate_with_composite_type("ag1", "0x80730003666f6f00806900040000002000");
    }

    @Test(groups={"short"})
    @DseVersion(value="6.0")
    public void should_parse_deterministic_aggregate() {
        String cqlFunction = String.format("CREATE FUNCTION %s.detf(i int, y int) RETURNS NULL ON NULL INPUT RETURNS int DETERMINISTIC LANGUAGE java AS 'return i+y;';", this.keyspace);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.deta(int) SFUNC detf STYPE int INITCOND 0 DETERMINISTIC;", this.keyspace);
        this.session().execute(cqlFunction);
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction("detf", new DataType[]{DataType.cint(), DataType.cint()});
        AggregateMetadata aggregate = keyspace.getAggregate("deta", new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)"deta(int)");
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)"deta");
        Assertions.assertThat((List)aggregate.getArgumentTypes()).containsExactly((Object[])new DataType[]{DataType.cint()});
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isEqualTo((Object)0);
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(DataType.cint());
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isTrue();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)cqlAggregate);
        Assertions.assertThat((String)aggregate.exportAsString()).isEqualTo((Object)String.format("CREATE AGGREGATE %s.deta(int)\n    SFUNC detf\n    STYPE int\n    INITCOND 0\n    DETERMINISTIC;", this.keyspace));
    }

    public void parse_and_format_aggregate_with_composite_type(String aggregateName, String initCond) {
        DataType.CustomType custom = DataType.custom((String)"org.apache.cassandra.db.marshal.DynamicCompositeType(s=>org.apache.cassandra.db.marshal.UTF8Type,i=>org.apache.cassandra.db.marshal.Int32Type)");
        String cqlFunction = String.format("CREATE FUNCTION %s.%s_id(i %s) RETURNS NULL ON NULL INPUT RETURNS %s LANGUAGE java AS 'return i;';", this.keyspace, aggregateName, custom, custom);
        this.session().execute(cqlFunction);
        String cqlAggregate = String.format("CREATE AGGREGATE %s.%s() SFUNC %s_id STYPE %s INITCOND %s;", this.keyspace, aggregateName, aggregateName, custom, initCond);
        String expectedAggregate = String.format("CREATE AGGREGATE %s.%s() SFUNC %s_id STYPE %s INITCOND 0x80730003666f6f00806900040000002000;", this.keyspace, aggregateName, aggregateName, custom);
        boolean agCount = false;
        this.session().execute(cqlAggregate);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata stateFunc = keyspace.getFunction(aggregateName + "_id", new DataType[]{custom});
        AggregateMetadata aggregate = keyspace.getAggregate(aggregateName, new DataType[0]);
        Assertions.assertThat(aggregate).isNotNull();
        Assertions.assertThat((String)aggregate.getSignature()).isEqualTo((Object)(aggregateName + "()"));
        Assertions.assertThat((String)aggregate.getSimpleName()).isEqualTo((Object)aggregateName);
        Assertions.assertThat((List)aggregate.getArgumentTypes()).isEmpty();
        Assertions.assertThat(aggregate.getFinalFunc()).isNull();
        Assertions.assertThat((Object)aggregate.getInitCond()).isEqualTo((Object)TestUtils.serializeForDynamicCompositeType("foo", 32));
        Assertions.assertThat(aggregate.getReturnType()).isEqualTo(custom);
        Assertions.assertThat(aggregate.getStateFunc()).isEqualTo(stateFunc);
        Assertions.assertThat(aggregate.getStateType()).isEqualTo(custom);
        Assertions.assertThat((boolean)aggregate.isDeterministic()).isFalse();
        Assertions.assertThat((String)aggregate.toString()).isEqualTo((Object)expectedAggregate);
    }

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TYPE IF NOT EXISTS %s.phone (number text)", this.keyspace), String.format("CREATE TYPE IF NOT EXISTS %s.\"Address\" (    street text,    city text,    zip int,    phones frozen<set<frozen<phone>>>,    location frozen<tuple<float, float>>)", this.keyspace));
    }
}

