/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.SimpleStatement;
import org.testng.annotations.Test;

public abstract class AbstractBatchIdempotencyTest {
    protected abstract TestBatch createBatch();

    @Test(groups={"unit"})
    public void isIdempotent_should_return_true_if_no_statements_added() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_true_if_all_statements_are_idempotent() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_false_if_any_statements_is_nonidempotent() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(false));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_null_if_no_nonidempotent_statements_and_some_are_nullidempotent() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(null));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isNull();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isNull();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_false_if_both_nonidempotent_and_nullidempotent_statements_present() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(null));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isNull();
        batch.add(this.statementWithIdempotency(false));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.add(this.statementWithIdempotency(null));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.add(this.statementWithIdempotency(false));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_override_flag_if_no_statements_added() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.setIdempotent(false);
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_override_flag_if_calculated_idempotency_true() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(true));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.setIdempotent(false);
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_override_flag_if_calculated_idempotency_null() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(null));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isNull();
        batch.setIdempotent(false);
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_override_flag_if_calculated_idempotency_false() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(false));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.setIdempotent(true);
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
    }

    @Test(groups={"unit"})
    public void isIdempotent_should_return_override_flag_if_calculated_idempotency_equals_override_value() {
        TestBatch batch = this.createBatch();
        Assertions.assertThat((Boolean)batch.isIdempotent()).isTrue();
        batch.add(this.statementWithIdempotency(false));
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
        batch.setIdempotent(false);
        Assertions.assertThat((Boolean)batch.isIdempotent()).isFalse();
    }

    private RegularStatement statementWithIdempotency(Boolean idempotency) {
        SimpleStatement statement = new SimpleStatement("fake statement");
        if (idempotency != null) {
            statement.setIdempotent(idempotency.booleanValue());
            Assertions.assertThat((Boolean)statement.isIdempotent()).isEqualTo((Object)idempotency);
        } else {
            Assertions.assertThat((Boolean)statement.isIdempotent()).isNull();
        }
        return statement;
    }

    protected static interface TestBatch {
        public void add(RegularStatement var1);

        public Boolean isIdempotent();

        public void setIdempotent(boolean var1);
    }
}

