/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.dse.geometry;

import java.io.Serializable;

/**
 * A thin wrapper around {@link Distance}, that gets substituted during the serialization /
 * deserialization process. This allows {@link Distance} to be immutable and reference centers'
 * OGC counterpart.
 */
class DistanceSerializationProxy implements Serializable {

    private static final long serialVersionUID = 1L;

    private final Point center;

    private final double radius;

    DistanceSerializationProxy(Distance distance) {
        this.center = distance.getCenter();
        this.radius = distance.getRadius();
    }

    private Object readResolve() {
        return new Distance(center, radius);
    }
}