/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.utils.MathUtils;
import java.util.Locale;
import java.util.Map;

public final class StringUtils {
    public static final String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERIC = "0123456789";
    public static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT);
    private static final char[] CHARS = ALPHANUMERIC.toCharArray();

    @NonNull
    public static String getUniqueName(@NonNull String prefix, int len) {
        return prefix + '-' + StringUtils.randomString(len);
    }

    @NonNull
    public static String randomString(int len) {
        char[] buf = new char[len];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = CHARS[MathUtils.RANDOM.get().nextInt(CHARS.length)];
        }
        return new String(buf);
    }

    private StringUtils() {
    }

    public static boolean isEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    @NonNull
    public static String getArrayString(@Nullable String[] strs, int idx) {
        return strs == null || idx < 0 || idx >= strs.length ? "" : strs[idx];
    }

    @NonNull
    public static String join(@NonNull CharSequence delimiter, @NonNull Iterable<?> tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @NonNull
    public static String toString(@Nullable Map<?, ?> map) {
        StringBuilder buf = new StringBuilder();
        if (map != null) {
            int i = 0;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                buf.append(entry.getKey()).append("=>").append(entry.getValue());
            }
        }
        return buf.toString();
    }
}

