/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLDictIterator;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MDict
extends MCollection
implements Iterable<String> {
    private final List<String> newKey = new ArrayList<String>();
    @NonNull
    private Map<String, MValue> valueMap = new HashMap<String, MValue>();
    @Nullable
    private FLDict flDict;
    private long valCount;

    public MDict() {
    }

    public MDict(@NonNull MValue mv, @Nullable MCollection parent) {
        this.initInSlot(mv, parent, parent != null && parent.hasMutableChildren());
    }

    public MDict(@NonNull MDict mDict, boolean isMutable) {
        super.initAsCopyOf(mDict, isMutable);
        this.flDict = mDict.flDict;
        this.valueMap = new HashMap<String, MValue>(mDict.valueMap);
        this.valCount = mDict.valCount;
    }

    public long count() {
        return this.valCount;
    }

    @NonNull
    public MValue get(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        MValue v = this.valueMap.get(key);
        if (v != null) {
            return v;
        }
        FLValue value = this.flDict == null ? null : this.flDict.get(key);
        return value == null ? MValue.EMPTY : this.setInMap(key, new MValue(value));
    }

    public boolean set(String key, @NonNull MValue value) {
        Preconditions.assertNotNull(key, "key");
        Preconditions.assertThat(this, "Cannot call set() on an immutable MDict", MCollection::isMutable);
        MValue oValue = this.valueMap.get(key);
        if (oValue != null) {
            if (value.isEmpty() && oValue.isEmpty()) {
                return true;
            }
            this.mutate();
            this.valCount += (long)((value.isEmpty() ? 0 : 1) - (oValue.isEmpty() ? 0 : 1));
            this.valueMap.put(key, value);
        } else {
            if (this.flDict != null && this.flDict.get(key) != null) {
                if (value.isEmpty()) {
                    --this.valCount;
                }
            } else {
                if (value.isEmpty()) {
                    return true;
                }
                ++this.valCount;
            }
            this.mutate();
            this.setInMap(key, value);
        }
        return true;
    }

    public boolean contains(String key) {
        Preconditions.assertNotNull(key, "key");
        MValue mValue = this.valueMap.get(key);
        return mValue != null ? !mValue.isEmpty() : this.flDict != null && this.flDict.get(key) != null;
    }

    @NonNull
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, MValue> entry : this.valueMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            keys.add(entry.getKey());
        }
        if (this.flDict != null && this.flDict.count() > 0L) {
            try (FLDictIterator itr = new FLDictIterator();){
                String key;
                itr.begin(this.flDict);
                while ((key = itr.getKeyString()) != null) {
                    if (!this.valueMap.containsKey(key)) {
                        keys.add(key);
                    }
                    itr.next();
                }
            }
        }
        return keys;
    }

    public boolean remove(String key) {
        return this.set(key, MValue.EMPTY);
    }

    public boolean clear() {
        Preconditions.assertThat(this, "Cannot call set on a non-mutable MDict", MCollection::isMutable);
        if (this.valCount == 0L) {
            return true;
        }
        this.mutate();
        this.valueMap.clear();
        if (this.flDict != null && this.flDict.count() > 0L) {
            try (FLDictIterator itr = new FLDictIterator();){
                String key;
                itr.begin(this.flDict);
                while ((key = itr.getKeyString()) != null) {
                    this.valueMap.put(key, MValue.EMPTY);
                    itr.next();
                }
            }
        }
        this.valCount = 0L;
        return true;
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        if (!this.isMutated()) {
            if (this.flDict != null) {
                enc.writeValue(this.flDict);
            } else {
                enc.beginDict(0L);
                enc.endDict();
            }
        } else {
            enc.beginDict(this.valCount);
            for (Map.Entry<String, MValue> entry : this.valueMap.entrySet()) {
                MValue value = entry.getValue();
                if (value.isEmpty()) continue;
                enc.writeKey(entry.getKey());
                value.encodeTo(enc);
            }
            if (this.flDict != null && this.flDict.count() > 0L) {
                try (FLDictIterator itr = new FLDictIterator();){
                    String key;
                    itr.begin(this.flDict);
                    while ((key = itr.getKeyString()) != null) {
                        if (!this.valueMap.containsKey(key)) {
                            enc.writeKey(key);
                            enc.writeValue(itr.getValue());
                        }
                        itr.next();
                    }
                }
            }
            enc.endDict();
        }
    }

    @Override
    protected final void initInSlot(@NonNull MValue mv, @Nullable MCollection parent, boolean isMutable) {
        super.initInSlot(mv, parent, isMutable);
        if (this.flDict != null) {
            throw new IllegalStateException("flDict is not null");
        }
        FLValue value = mv.getValue();
        if (value == null) {
            this.flDict = null;
            this.valCount = 0L;
            return;
        }
        this.flDict = value.asFLDict();
        this.valCount = this.flDict.count();
    }

    @NonNull
    private MValue setInMap(@NonNull String key, @NonNull MValue value) {
        this.newKey.add(key);
        this.valueMap.put(key, value);
        return value;
    }
}

