/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLDictIterator;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class FLDict {
    private final long handle;

    public FLDict(long handle) {
        this.handle = Preconditions.assertNotZero(handle, "handle");
    }

    @NonNull
    public FLValue toFLValue() {
        return new FLValue(this.handle);
    }

    public long count() {
        return FLDict.count(this.handle);
    }

    @Nullable
    public FLValue get(@Nullable String key) {
        if (key == null) {
            return null;
        }
        long hValue = FLDict.get(this.handle, key.getBytes(StandardCharsets.UTF_8));
        return hValue != 0L ? new FLValue(hValue) : null;
    }

    @NonNull
    public Map<String, Object> asDict() {
        String key;
        HashMap<String, Object> results = new HashMap<String, Object>();
        FLDictIterator itr = new FLDictIterator();
        itr.begin(this);
        while ((key = itr.getKeyString()) != null) {
            FLValue val = itr.getValue();
            results.put(key, val == null ? null : val.asObject());
            itr.next();
        }
        return results;
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.handle);
    }

    static native long count(long var0);

    static native long get(long var0, byte[] var2);
}

