/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import com.couchbase.lite.internal.support.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientTask<T> {
    private static final CBLExecutor EXECUTOR = new CBLExecutor("Client worker", 4, 8, new SynchronousQueue<Runnable>());
    @NonNull
    private final Callable<T> task;
    private T result;
    @Nullable
    private Exception err;

    public static void dumpState() {
        EXECUTOR.dumpState();
        AbstractExecutionService.dumpThreads();
    }

    public ClientTask(@NonNull Callable<T> task) {
        this.task = task;
    }

    public void execute() {
        this.execute(30L, TimeUnit.SECONDS);
    }

    public void execute(long timeout, @NonNull TimeUnit timeUnit) {
        FutureTask<T> future = new FutureTask<T>(this.task);
        try {
            EXECUTOR.execute(new InstrumentedTask(future, null));
        }
        catch (RuntimeException e) {
            Log.w(LogDomain.DATABASE, "!!! Catastrophic executor failure (ClientTask)", e);
            if (!AbstractExecutionService.throttled()) {
                ClientTask.dumpState();
            }
            throw e;
        }
        try {
            this.result = future.get(timeout, timeUnit);
        }
        catch (InterruptedException | TimeoutException e) {
            this.err = e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (!(t instanceof Exception)) {
                throw new Error("Client task error", t);
            }
            this.err = (Exception)t;
        }
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    @Nullable
    public Exception getFailure() {
        return this.err;
    }
}

