/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4NativePeer;

@VisibleForTesting
public class C4RawDocument
extends C4NativePeer {
    C4RawDocument(long peer) {
        super(peer);
    }

    @Nullable
    public String key() {
        return C4RawDocument.key(this.getPeer());
    }

    @Nullable
    public String meta() {
        return C4RawDocument.meta(this.getPeer());
    }

    @NonNull
    public byte[] body() {
        return C4RawDocument.body(this.getPeer());
    }

    @Override
    @CallSuper
    public void close() throws LiteCoreException {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) throws LiteCoreException {
        this.releasePeer(domain, C4Database::rawFreeDocument);
    }

    @NonNull
    private static native String key(long var0);

    @NonNull
    private static native String meta(long var0);

    @NonNull
    private static native byte[] body(long var0);
}

