/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.ConsoleLogger;
import com.couchbase.lite.Database;
import com.couchbase.lite.Log;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.Fn;
import java.util.concurrent.atomic.AtomicReference;

public final class C4Log {
    @NonNull
    private static final AtomicReference<LogLevel> CALLBACK_LEVEL = new AtomicReference<LogLevel>(LogLevel.NONE);
    @Nullable
    private static volatile Fn.Consumer<RawLog> rawListener;

    private C4Log() {
    }

    @VisibleForTesting
    public static void registerListener(Fn.Consumer<RawLog> listener) {
        rawListener = listener;
    }

    public static void logCallback(@NonNull String c4Domain, int c4Level, @NonNull String message) {
        LogLevel newCallbackLevel;
        Fn.Consumer<RawLog> listener = rawListener;
        if (listener != null) {
            listener.accept(new RawLog(c4Domain, c4Level, message));
        }
        LogLevel level = com.couchbase.lite.internal.support.Log.getLogLevelForC4Level(c4Level);
        LogDomain domain = com.couchbase.lite.internal.support.Log.getLoggingDomainForC4Domain(c4Domain);
        Log logger = Database.log;
        ConsoleLogger console = logger.getConsole();
        console.log(level, domain, message);
        Logger custom = logger.getCustom();
        if (custom != null) {
            custom.log(level, domain, message);
        }
        if (CALLBACK_LEVEL.getAndSet(newCallbackLevel = C4Log.getCallbackLevel(console.getLevel(), custom)) == newCallbackLevel) {
            return;
        }
        CouchbaseLiteInternal.getExecutionService().getDefaultExecutor().execute(C4Log::setCoreCallbackLevel);
    }

    public static void setLevels(int level, String ... domains) {
        if (domains == null || domains.length <= 0) {
            return;
        }
        for (String domain : domains) {
            C4Log.setLevel(domain, level);
        }
    }

    @NonNull
    public static LogLevel getCallbackLevel() {
        return CALLBACK_LEVEL.get();
    }

    public static void setCallbackLevel(@NonNull LogLevel consoleLevel) {
        LogLevel newLogLevel = C4Log.getCallbackLevel(consoleLevel, Database.log.getCustom());
        if (CALLBACK_LEVEL.getAndSet(newLogLevel) == newLogLevel) {
            return;
        }
        C4Log.setCoreCallbackLevel();
    }

    @VisibleForTesting
    public static void forceCallbackLevel(@NonNull LogLevel logLevel) {
        CALLBACK_LEVEL.set(logLevel);
        C4Log.setCoreCallbackLevel();
    }

    private static void setCoreCallbackLevel() {
        LogLevel logLevel = CALLBACK_LEVEL.get();
        C4Log.setCallbackLevel(com.couchbase.lite.internal.support.Log.getC4LevelForLogLevel(logLevel));
    }

    @NonNull
    private static LogLevel getCallbackLevel(@NonNull LogLevel consoleLevel, @Nullable Logger customLogger) {
        if (customLogger == null) {
            return consoleLevel;
        }
        LogLevel customLogLevel = customLogger.getLevel();
        return customLogLevel.compareTo(consoleLevel) > 0 ? consoleLevel : customLogLevel;
    }

    public static native void log(String var0, int var1, String var2);

    public static native int getBinaryFileLevel();

    public static native void setBinaryFileLevel(int var0);

    public static native void writeToBinaryFile(String var0, int var1, int var2, long var3, boolean var5, String var6);

    @VisibleForTesting
    public static native int getLevel(String var0);

    private static native void setCallbackLevel(int var0);

    private static native void setLevel(String var0, int var1);

    @VisibleForTesting
    public static class RawLog {
        @NonNull
        public final String domain;
        public final int level;
        @NonNull
        public final String message;

        RawLog(@NonNull String domain, int level, @NonNull String message) {
            this.domain = domain;
            this.level = level;
            this.message = message;
        }

        @NonNull
        public String toString() {
            return "RawLog{" + this.domain + "/" + this.level + ": " + this.message + "}";
        }
    }
}

