/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4DocumentObserverListener;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.support.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class C4DocumentObserver
extends C4NativePeer {
    private static final Map<Long, C4DocumentObserver> REVERSE_LOOKUP_TABLE = Collections.synchronizedMap(new HashMap());
    @NonNull
    private final C4DocumentObserverListener listener;
    @NonNull
    private final Object context;

    @NonNull
    static C4DocumentObserver newObserver(long db, @NonNull String docID, @NonNull C4DocumentObserverListener listener, @NonNull Object context) {
        C4DocumentObserver observer = new C4DocumentObserver(db, docID, listener, context);
        REVERSE_LOOKUP_TABLE.put(observer.getPeer(), observer);
        return observer;
    }

    static void callback(long peer, @Nullable String docID, long sequence) {
        Log.d(LogDomain.DATABASE, "C4DocumentObserver.callback @0x%x (%s): %s", peer, sequence, docID);
        C4DocumentObserver obs = REVERSE_LOOKUP_TABLE.get(peer);
        if (obs == null) {
            return;
        }
        obs.listener.callback(obs, docID, sequence, obs.context);
    }

    C4DocumentObserver(long db, @NonNull String docID, @NonNull C4DocumentObserverListener listener, @NonNull Object context) {
        super(C4DocumentObserver.create(db, docID));
        this.listener = listener;
        this.context = context;
    }

    @Override
    @CallSuper
    public void close() {
        REVERSE_LOOKUP_TABLE.remove(this.getPeerUnchecked());
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4DocumentObserver::free);
    }

    private static native long create(long var0, String var2);

    private static native void free(long var0);
}

