/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.fleece.FLSliceResult;

public class C4Document
extends C4NativePeer {
    public static boolean dictContainsBlobs(@NonNull FLSliceResult dict, @NonNull FLSharedKeys sk) {
        return C4Document.dictContainsBlobs(dict.getHandle(), sk.getHandle());
    }

    C4Document(long db, @NonNull String docID, boolean mustExist) throws LiteCoreException {
        this(C4Document.get(db, docID, mustExist));
    }

    C4Document(long db, long sequence) throws LiteCoreException {
        this(C4Document.getBySequence(db, sequence));
    }

    C4Document(long peer) {
        super(peer);
    }

    public int getFlags() {
        return this.withPeer(0, C4Document::getFlags);
    }

    @Nullable
    public String getDocID() {
        return this.withPeerOrNull(C4Document::getDocID);
    }

    @Nullable
    public String getRevID() {
        return this.withPeerOrNull(C4Document::getRevID);
    }

    public long getSequence() {
        return this.withPeer(0L, C4Document::getSequence);
    }

    @Nullable
    public String getSelectedRevID() {
        return this.withPeerOrNull(C4Document::getSelectedRevID);
    }

    public long getSelectedSequence() {
        return this.withPeer(0L, C4Document::getSelectedSequence);
    }

    @Nullable
    public FLDict getSelectedBody2() {
        long value = this.withPeer(0L, C4Document::getSelectedBody2);
        return value == 0L ? null : new FLDict(value);
    }

    public int getSelectedFlags() {
        return this.withPeer(0, C4Document::getSelectedFlags);
    }

    public void save(int maxRevTreeDepth) throws LiteCoreException {
        C4Document.save(this.getPeer(), maxRevTreeDepth);
    }

    public boolean selectNextRevision() {
        return this.withPeer(false, C4Document::selectNextRevision);
    }

    public void selectNextLeafRevision(boolean includeDeleted, boolean withBody) throws LiteCoreException {
        C4Document.selectNextLeafRevision(this.getPeer(), includeDeleted, withBody);
    }

    public void resolveConflict(String winningRevID, String losingRevID, byte[] mergeBody, int mergedFlags) throws LiteCoreException {
        C4Document.resolveConflict(this.getPeer(), winningRevID, losingRevID, mergeBody, mergedFlags);
    }

    @Nullable
    public C4Document update(@Nullable FLSliceResult body, int flags) throws LiteCoreException {
        long bodyHandle = body != null ? body.getHandle() : 0L;
        long newDoc = this.withPeer(0L, h -> C4Document.update2(h, bodyHandle, flags));
        return newDoc == 0L ? null : new C4Document(newDoc);
    }

    @VisibleForTesting
    @Nullable
    public C4Document update(@NonNull byte[] body, int flags) throws LiteCoreException {
        long newDoc = this.withPeer(0L, h -> C4Document.update(h, body, flags));
        return newDoc == 0L ? null : new C4Document(newDoc);
    }

    public boolean deleted() {
        return this.isSelectedRevFlags(1);
    }

    public boolean exists() {
        return this.isFlags(4096);
    }

    public boolean isSelectedRevFlags(int flag) {
        return (this.getSelectedFlags() & flag) == flag;
    }

    @Nullable
    public String bodyAsJSON(boolean canonical) throws LiteCoreException {
        return this.withPeerOrNull(h -> C4Document.bodyAsJSON(h, canonical));
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(null);
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @Nullable
    byte[] getSelectedBody() {
        return this.withPeerOrNull(C4Document::getSelectedBody);
    }

    @VisibleForTesting
    int purgeRevision(String revID) throws LiteCoreException {
        return this.withPeer(0, h -> C4Document.purgeRevision(h, revID));
    }

    @VisibleForTesting
    boolean selectCurrentRevision() {
        return this.withPeer(false, C4Document::selectCurrentRevision);
    }

    @VisibleForTesting
    void loadRevisionBody() throws LiteCoreException {
        C4Document.loadRevisionBody(this.getPeer());
    }

    @VisibleForTesting
    boolean hasRevisionBody() {
        return this.withPeer(false, C4Document::hasRevisionBody);
    }

    @VisibleForTesting
    boolean selectParentRevision() {
        return this.withPeer(false, C4Document::selectParentRevision);
    }

    @VisibleForTesting
    boolean selectCommonAncestorRevision(String revID1, String revID2) {
        return this.withPeer(false, h -> C4Document.selectCommonAncestorRevision(h, revID1, revID2));
    }

    private boolean isFlags(int flag) {
        return (this.getFlags() & flag) == flag;
    }

    private boolean conflicted() {
        return this.isFlags(2);
    }

    private boolean accessRemoved() {
        return this.isSelectedRevFlags(128);
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4Document::free);
    }

    static native void setExpiration(long var0, String var2, long var3) throws LiteCoreException;

    static native long getExpiration(long var0, String var2) throws LiteCoreException;

    static native long create(long var0, String var2, byte[] var3, int var4) throws LiteCoreException;

    static native long create2(long var0, String var2, long var3, int var5) throws LiteCoreException;

    static native long put(long var0, byte[] var2, String var3, int var4, boolean var5, boolean var6, String[] var7, boolean var8, int var9, int var10) throws LiteCoreException;

    static native long put2(long var0, long var2, String var4, int var5, boolean var6, boolean var7, String[] var8, boolean var9, int var10, int var11) throws LiteCoreException;

    private static native int getFlags(long var0);

    @NonNull
    private static native String getDocID(long var0);

    @NonNull
    private static native String getRevID(long var0);

    private static native long getSequence(long var0);

    @NonNull
    private static native String getSelectedRevID(long var0);

    private static native int getSelectedFlags(long var0);

    private static native long getSelectedSequence(long var0);

    @NonNull
    private static native byte[] getSelectedBody(long var0);

    private static native long getSelectedBody2(long var0);

    private static native long get(long var0, String var2, boolean var3) throws LiteCoreException;

    private static native long getBySequence(long var0, long var2) throws LiteCoreException;

    private static native void save(long var0, int var2) throws LiteCoreException;

    private static native void free(long var0);

    private static native boolean selectCurrentRevision(long var0);

    private static native void loadRevisionBody(long var0) throws LiteCoreException;

    private static native boolean hasRevisionBody(long var0);

    private static native boolean selectParentRevision(long var0);

    private static native boolean selectNextRevision(long var0);

    private static native void selectNextLeafRevision(long var0, boolean var2, boolean var3) throws LiteCoreException;

    private static native boolean selectCommonAncestorRevision(long var0, String var2, String var3);

    private static native int purgeRevision(long var0, String var2) throws LiteCoreException;

    private static native void resolveConflict(long var0, String var2, String var3, byte[] var4, int var5) throws LiteCoreException;

    private static native long update(long var0, byte[] var2, int var3) throws LiteCoreException;

    private static native long update2(long var0, long var2, int var4) throws LiteCoreException;

    @Nullable
    private static native String bodyAsJSON(long var0, boolean var2) throws LiteCoreException;

    private static native boolean dictContainsBlobs(long var0, long var2);
}

