/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4BlobKey;
import com.couchbase.lite.internal.core.C4BlobReadStream;
import com.couchbase.lite.internal.core.C4BlobWriteStream;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import java.io.File;

public abstract class C4BlobStore
extends C4NativePeer {
    @NonNull
    public static C4BlobStore getUnmanagedBlobStore(long peer) throws LiteCoreException {
        return new UnmanagedC4BlobStore(peer);
    }

    @VisibleForTesting
    @NonNull
    public static C4BlobStore open(@NonNull String dirPath, long flags) throws LiteCoreException {
        return new ManagedC4BlobStore(dirPath.endsWith(File.separator) ? dirPath : dirPath + File.separator, flags);
    }

    C4BlobStore(long peer) {
        super(peer);
    }

    public long getSize(@NonNull C4BlobKey blobKey) {
        return C4BlobStore.getSize(this.getPeer(), this.getBlobKeyPeer(blobKey));
    }

    @NonNull
    public FLSliceResult getContents(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return FLSliceResult.getManagedSliceResult(C4BlobStore.getContents(this.getPeer(), this.getBlobKeyPeer(blobKey)));
    }

    @Nullable
    public String getFilePath(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return C4BlobStore.getFilePath(this.getPeer(), this.getBlobKeyPeer(blobKey));
    }

    @NonNull
    public C4BlobKey create(@NonNull byte[] contents) throws LiteCoreException {
        return new C4BlobKey(C4BlobStore.create(this.getPeer(), contents));
    }

    public void delete(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        C4BlobStore.delete(this.getPeer(), this.getBlobKeyPeer(blobKey));
    }

    @NonNull
    public C4BlobReadStream openReadStream(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return new C4BlobReadStream(C4BlobStore.openReadStream(this.getPeer(), this.getBlobKeyPeer(blobKey)));
    }

    @NonNull
    public C4BlobWriteStream openWriteStream() throws LiteCoreException {
        return new C4BlobWriteStream(C4BlobStore.openWriteStream(this.getPeer()));
    }

    @Override
    public abstract void close();

    @VisibleForTesting
    public void delete() throws LiteCoreException {
        this.releasePeer(null, C4BlobStore::deleteStore);
    }

    private long getBlobKeyPeer(@NonNull C4BlobKey blobKey) {
        return blobKey.getHandle();
    }

    private static native long getBlobStore(long var0) throws LiteCoreException;

    private static native long getSize(long var0, long var2);

    private static native long getContents(long var0, long var2) throws LiteCoreException;

    @NonNull
    private static native String getFilePath(long var0, long var2) throws LiteCoreException;

    private static native long create(long var0, byte[] var2) throws LiteCoreException;

    private static native void delete(long var0, long var2) throws LiteCoreException;

    private static native long openReadStream(long var0, long var2) throws LiteCoreException;

    private static native long openWriteStream(long var0) throws LiteCoreException;

    @VisibleForTesting
    private static native long openStore(String var0, long var1) throws LiteCoreException;

    @VisibleForTesting
    private static native void deleteStore(long var0) throws LiteCoreException;

    @VisibleForTesting
    private static native void freeStore(long var0);

    @VisibleForTesting
    private static final class ManagedC4BlobStore
    extends C4BlobStore {
        ManagedC4BlobStore(@NonNull String dirPath, long flags) throws LiteCoreException {
            super(C4BlobStore.openStore(dirPath, flags));
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, x$0 -> C4BlobStore.freeStore(x$0));
        }
    }

    private static final class UnmanagedC4BlobStore
    extends C4BlobStore {
        UnmanagedC4BlobStore(long peer) throws LiteCoreException {
            super(C4BlobStore.getBlobStore(peer));
        }

        @Override
        public void close() {
            this.releasePeer();
        }
    }
}

