/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;

public class C4BlobReadStream
extends C4NativePeer {
    C4BlobReadStream(long peer) {
        super(peer);
    }

    @NonNull
    public byte[] read(long maxBytesToRead) throws LiteCoreException {
        return C4BlobReadStream.read(this.getPeer(), maxBytesToRead);
    }

    public int read(byte[] b, int offset, long maxBytesToRead) throws LiteCoreException {
        return C4BlobReadStream.read(this.getPeer(), b, offset, maxBytesToRead);
    }

    public long getLength() throws LiteCoreException {
        return C4BlobReadStream.getLength(this.getPeer());
    }

    public void seek(long position) throws LiteCoreException {
        C4BlobReadStream.seek(this.getPeer(), position);
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4BlobReadStream::close);
    }

    @NonNull
    private static native byte[] read(long var0, long var2) throws LiteCoreException;

    private static native int read(long var0, byte[] var2, int var3, long var4) throws LiteCoreException;

    private static native long getLength(long var0) throws LiteCoreException;

    private static native void seek(long var0, long var2) throws LiteCoreException;

    private static native void close(long var0);
}

