/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.BuilderQuery;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.From;
import com.couchbase.lite.FromRouter;
import com.couchbase.lite.SelectResult;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Select
extends BuilderQuery
implements FromRouter {
    private final boolean distinct;
    @NonNull
    private final List<SelectResult> selectResults;

    Select(boolean distinct, SelectResult ... selectResults) {
        this.distinct = distinct;
        this.selectResults = Arrays.asList(selectResults);
        this.setSelect(this);
    }

    @Override
    @NonNull
    public From from(@NonNull DataSource dataSource) {
        Preconditions.assertNotNull(dataSource, "dataSource");
        return new From(this, dataSource);
    }

    @NonNull
    List<SelectResult> getSelectResults() {
        return this.selectResults;
    }

    boolean isDistinct() {
        return this.distinct;
    }

    boolean hasSelectResults() {
        return !this.selectResults.isEmpty();
    }

    @NonNull
    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (SelectResult sr : this.selectResults) {
            json.add(sr.asJSON());
        }
        return json;
    }
}

