/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;

final class ReplicatorChangeListenerToken
implements ListenerToken {
    @NonNull
    private final ReplicatorChangeListener listener;
    @Nullable
    private final Executor executor;

    ReplicatorChangeListenerToken(@Nullable Executor executor, @NonNull ReplicatorChangeListener listener) {
        this.executor = executor;
        this.listener = Preconditions.assertNotNull(listener, "listener");
    }

    void notify(@NonNull ReplicatorChange change) {
        this.getExecutor().execute(() -> this.listener.changed(change));
    }

    @NonNull
    Executor getExecutor() {
        return this.executor != null ? this.executor : CouchbaseLiteInternal.getExecutionService().getDefaultExecutor();
    }
}

