/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.BuilderQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.Ordering;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class OrderBy
extends BuilderQuery
implements LimitRouter {
    @NonNull
    private final List<Ordering> orderings;

    OrderBy(@NonNull BuilderQuery query, @NonNull List<Ordering> orderings) {
        this.copy(query);
        this.orderings = orderings;
        this.setOrderBy(this);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        return this.limit(limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, @Nullable Expression offset) {
        Preconditions.assertNotNull(limit, "limit");
        return new Limit(this, limit, offset);
    }

    @NonNull
    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (Ordering ordering : this.orderings) {
            json.add(ordering.asJSON());
        }
        return json;
    }
}

