/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Database;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Document;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.MutableDictionaryInterface;
import com.couchbase.lite.internal.core.C4Document;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class MutableDocument
extends Document
implements MutableDictionaryInterface {
    @NonNull
    private static String createUUID() {
        return UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH);
    }

    public MutableDocument() {
        this((String)null);
    }

    public MutableDocument(@Nullable String id) {
        this(null, id, null);
    }

    public MutableDocument(@NonNull Map<String, Object> data) {
        this(null, data);
    }

    public MutableDocument(@Nullable String id, @NonNull Map<String, Object> data) {
        this(null, id, null);
        if (data != null) {
            this.setData((Map)data);
        }
    }

    public MutableDocument(@Nullable String id, @NonNull String json) {
        this(null, id, null);
        this.setJSON(json);
    }

    protected MutableDocument(@NonNull Document doc) {
        this(doc.getDatabase(), doc.getId(), doc.getC4doc());
        if (doc.isMutable()) {
            this.setContent(doc.getContent().toMutable());
        }
    }

    MutableDocument(@NonNull String id, @NonNull Document doc) {
        this(doc.getDatabase(), id, null);
        this.setData((Map)doc.getContent().toMap());
    }

    private MutableDocument(@Nullable Database database, @Nullable String id, @Nullable C4Document c4doc) {
        super(database, id != null ? id : MutableDocument.createUUID(), c4doc, true);
    }

    @Override
    @NonNull
    public MutableDocument toMutable() {
        return new MutableDocument(this);
    }

    @Override
    @NonNull
    public MutableDocument setData(@NonNull Map<String, Object> data) {
        this.getMutableContent().setData((Map)data);
        return this;
    }

    @Override
    @NonNull
    public MutableDocument setJSON(@NonNull String json) {
        this.getMutableContent().setJSON(json);
        return this;
    }

    @Override
    @NonNull
    public MutableDocument setValue(@NonNull String key, @Nullable Object value) {
        this.getMutableContent().setValue(key, value);
        return this;
    }

    @Override
    @NonNull
    public MutableDocument setString(@NonNull String key, @Nullable String value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setNumber(@NonNull String key, @Nullable Number value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setInt(@NonNull String key, int value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setLong(@NonNull String key, long value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setFloat(@NonNull String key, float value) {
        return this.setValue(key, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableDocument setDouble(@NonNull String key, double value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setBoolean(@NonNull String key, boolean value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setBlob(@NonNull String key, @Nullable Blob value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setDate(@NonNull String key, @Nullable Date value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setArray(@NonNull String key, @Nullable Array value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setDictionary(@NonNull String key, @Nullable Dictionary value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument remove(@NonNull String key) {
        this.getMutableContent().remove(key);
        return this;
    }

    @Override
    @Nullable
    public MutableArray getArray(@NonNull String key) {
        return this.getMutableContent().getArray(key);
    }

    @Override
    @Nullable
    public MutableDictionary getDictionary(@NonNull String key) {
        return this.getMutableContent().getDictionary(key);
    }

    @Override
    @NonNull
    public String toJSON() {
        throw new IllegalStateException("Mutable objects may not be encoded as JSON");
    }

    @Override
    long generation() {
        return super.generation() + (long)(this.isChanged() ? 1 : 0);
    }

    private boolean isChanged() {
        return this.getMutableContent().isChanged();
    }

    @NonNull
    private MutableDictionary getMutableContent() {
        return (MutableDictionary)this.getContent();
    }
}

