/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.BuilderQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Join;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.OrderByRouter;
import com.couchbase.lite.Ordering;
import com.couchbase.lite.Where;
import com.couchbase.lite.WhereRouter;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Joins
extends BuilderQuery
implements WhereRouter,
OrderByRouter,
LimitRouter {
    @NonNull
    private final List<Join> joins;

    Joins(@NonNull BuilderQuery query, @NonNull List<Join> joins) {
        this.copy(query);
        this.joins = joins;
        this.setJoins(this);
    }

    @Override
    @NonNull
    public Where where(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new Where(this, expression);
    }

    @Override
    @NonNull
    public OrderBy orderBy(Ordering ... orderings) {
        Preconditions.assertNotNull(orderings, "orderings");
        return new OrderBy(this, Arrays.asList(orderings));
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        return this.limit(limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, @Nullable Expression offset) {
        Preconditions.assertNotNull(limit, "limit");
        return new Limit(this, limit, offset);
    }

    @NonNull
    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (Join join : this.joins) {
            json.add(join.asJSON());
        }
        return json;
    }
}

