/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.MRoot;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Document
implements DictionaryInterface,
Iterable<String> {
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final String id;
    private final boolean mutable;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    @GuardedBy(value="lock")
    @NonNull
    private Dictionary internalDict;
    @GuardedBy(value="lock")
    @Nullable
    private C4Document c4Document;
    @GuardedBy(value="lock")
    @Nullable
    private Database database;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    @GuardedBy(value="lock")
    @Nullable
    private FLDict data;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    @GuardedBy(value="lock")
    @Nullable
    private MRoot root;
    @GuardedBy(value="lock")
    @Nullable
    private String revId;

    private static long generationFromRevID(String revID) {
        long generation = 0L;
        long length = Math.min(revID == null ? 0 : revID.length(), 9);
        int i = 0;
        while ((long)i < length) {
            char c = revID.charAt(i);
            if (!Character.isDigit(c)) {
                if (c != '-') break;
                return generation;
            }
            generation = 10L * generation + (long)Character.getNumericValue(c);
            ++i;
        }
        return 0L;
    }

    @NonNull
    static Document getDocument(@NonNull Database database, @NonNull String id) throws CouchbaseLiteException {
        return Document.getDocument(database, id, true);
    }

    @NonNull
    static Document getDocument(@NonNull Database database, @NonNull String id, boolean includeDeleted) throws CouchbaseLiteException {
        C4Document c4Doc;
        Preconditions.assertNotNull(database, "database");
        try {
            c4Doc = database.getC4Document(id);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        if (includeDeleted || (c4Doc.getFlags() & 1) == 0) {
            return new Document(database, id, c4Doc, false);
        }
        throw new CouchbaseLiteException("DocumentNotFound", "CouchbaseLite", 7);
    }

    protected Document(@Nullable Database database, @NonNull String id, @Nullable C4Document c4doc, boolean mutable) {
        this.database = database;
        this.id = Preconditions.assertNotNull(id, "id");
        this.mutable = mutable;
        this.setC4Document(c4doc, mutable);
    }

    Document(@NonNull Database database, @NonNull String id, @Nullable String revId, @Nullable FLDict body) {
        this(database, id, null, false);
        this.revId = revId;
        this.setContentLocked(body, false);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getRevisionID() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document == null ? this.revId : this.c4Document.getSelectedRevID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSequence() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document == null ? 0L : this.c4Document.getSelectedSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableDocument toMutable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.revId != null) {
                throw new UnsupportedOperationException("Editing replication filter documents not supported");
            }
        }
        return new MutableDocument(this);
    }

    @Override
    public int count() {
        return this.getContent().count();
    }

    @Override
    @NonNull
    public List<String> getKeys() {
        return this.getContent().getKeys();
    }

    @Override
    @Nullable
    public Object getValue(@NonNull String key) {
        return this.getContent().getValue(key);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key) {
        return this.getContent().getString(key);
    }

    @Override
    @Nullable
    public Number getNumber(@NonNull String key) {
        return this.getContent().getNumber(key);
    }

    @Override
    public int getInt(@NonNull String key) {
        return this.getContent().getInt(key);
    }

    @Override
    public long getLong(@NonNull String key) {
        return this.getContent().getLong(key);
    }

    @Override
    public float getFloat(@NonNull String key) {
        return this.getContent().getFloat(key);
    }

    @Override
    public double getDouble(@NonNull String key) {
        return this.getContent().getDouble(key);
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        return this.getContent().getBoolean(key);
    }

    @Override
    @Nullable
    public Blob getBlob(@NonNull String key) {
        return this.getContent().getBlob(key);
    }

    @Override
    @Nullable
    public Date getDate(@NonNull String key) {
        return this.getContent().getDate(key);
    }

    @Override
    @Nullable
    public Array getArray(@NonNull String key) {
        return this.getContent().getArray(key);
    }

    @Override
    @Nullable
    public Dictionary getDictionary(@NonNull String key) {
        return this.getContent().getDictionary(key);
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        return this.getContent().toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String toJSON() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.c4Document != null) {
                    return this.c4Document.bodyAsJSON(true);
                }
            }
        }
        catch (LiteCoreException e) {
            Log.i(LogDomain.DATABASE, "Failed encoding document", CouchbaseLiteException.convertException(e));
        }
        return null;
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.getContent().contains(key);
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document doc = (Document)o;
        Database db = this.getDatabase();
        Database otherDb = doc.getDatabase();
        if (db == null ? otherDb != null : !db.equalsWithPath(otherDb)) {
            return false;
        }
        if (!this.id.equals(doc.id)) {
            return false;
        }
        return this.getContent().equals(doc.getContent());
    }

    public int hashCode() {
        String path;
        Database db = this.getDatabase();
        int result = 0;
        if (db != null && (path = db.getPath()) != null) {
            result = path.hashCode();
        }
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.getContent().hashCode();
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Document{").append(ClassUtils.objId(this)).append(this.id).append('@').append(this.getRevisionID()).append('(').append(this.isMutable() ? (char)'+' : '.').append(this.isDeleted() ? (char)'?' : '.').append("):");
        boolean first = true;
        for (String key : this.getKeys()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(key).append("=>").append(this.getValue(key));
        }
        return buf.append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final Dictionary getContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setContent(@NonNull Dictionary content) {
        Preconditions.assertNotNull(content, "content");
        Object object = this.lock;
        synchronized (object) {
            this.internalDict = content;
        }
    }

    final boolean isMutable() {
        return this.mutable;
    }

    long generation() {
        return Document.generationFromRevID(this.getRevisionID());
    }

    final boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    final boolean isNewDocument() {
        return this.getRevisionID() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean exists() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document != null && this.c4Document.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDeleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document != null && this.c4Document.deleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final Database getDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.database;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDatabase(@Nullable Database database) {
        Object object = this.lock;
        synchronized (object) {
            this.database = database;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final C4Document getC4doc() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replaceC4Document(@Nullable C4Document c4doc) {
        Object object = this.lock;
        synchronized (object) {
            this.updateC4DocumentLocked(c4doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean selectConflictingRevision() throws LiteCoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4Document == null) {
                return false;
            }
            boolean foundConflict = false;
            while (!foundConflict) {
                try {
                    this.c4Document.selectNextLeafRevision(true, true);
                }
                catch (LiteCoreException e) {
                    if (e.code == 0) break;
                    throw e;
                }
                foundConflict = this.c4Document.isSelectedRevFlags(32);
            }
            if (foundConflict) {
                this.setC4Document(this.c4Document, this.isMutable());
            }
            return foundConflict;
        }
    }

    @NonNull
    final FLSliceResult encode() throws LiteCoreException {
        Database db = this.getDatabase();
        if (db == null) {
            throw new IllegalStateException("encode called with null database");
        }
        try (FLEncoder encoder = db.getSharedFleeceEncoder();){
            encoder.setArg("BLOB.db", this.getDatabase());
            this.getContent().encodeTo(encoder);
            FLSliceResult fLSliceResult = encoder.finish2();
            return fLSliceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setC4Document(@Nullable C4Document c4doc, boolean mutable) {
        Object object = this.lock;
        synchronized (object) {
            this.updateC4DocumentLocked(c4doc);
            this.setContentLocked(c4doc == null || c4doc.deleted() ? null : c4doc.getSelectedBody2(), mutable);
        }
    }

    @GuardedBy(value="lock")
    private void updateC4DocumentLocked(@Nullable C4Document c4Doc) {
        if (this.c4Document == c4Doc) {
            return;
        }
        this.c4Document = c4Doc;
        if (c4Doc != null) {
            this.revId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private void setContentLocked(@Nullable FLDict data, boolean mutable) {
        this.data = data;
        if (data == null) {
            this.root = null;
            this.internalDict = mutable ? new MutableDictionary() : new Dictionary();
            return;
        }
        Database db = this.getDatabase();
        if (db == null) {
            throw new IllegalStateException("document has not been saved to a database");
        }
        MRoot newRoot = new MRoot(new DocContext(db, this.c4Document), data.toFLValue(), mutable);
        Dictionary dict = (Dictionary)Preconditions.assertNotNull(newRoot.asNative(), "root dictionary");
        this.root = newRoot;
        Object object = db.getDbLock();
        synchronized (object) {
            this.internalDict = dict;
        }
    }
}

