/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.ChangeListener;
import com.couchbase.lite.ChangeListenerToken;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

class ChangeNotifier<T> {
    private final Object lock = new Object();
    private final Set<ChangeListenerToken<T>> listenerTokens = new HashSet<ChangeListenerToken<T>>();

    ChangeNotifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ChangeListenerToken<T> addChangeListener(@Nullable Executor executor, @NonNull ChangeListener<T> listener) {
        Preconditions.assertNotNull(listener, "listener");
        Object object = this.lock;
        synchronized (object) {
            ChangeListenerToken<T> token = new ChangeListenerToken<T>(executor, listener);
            this.listenerTokens.add(token);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        Object object = this.lock;
        synchronized (object) {
            this.listenerTokens.remove(token);
            return this.listenerTokens.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postChange(T change) {
        Preconditions.assertNotNull(change, "change");
        Object object = this.lock;
        synchronized (object) {
            for (ChangeListenerToken<T> token : this.listenerTokens) {
                token.postChange(change);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postChange(Fn.Provider<T> changeFactory) {
        Preconditions.assertNotNull(changeFactory, "changeFactory");
        Object object = this.lock;
        synchronized (object) {
            for (ChangeListenerToken<T> token : this.listenerTokens) {
                token.postChange(changeFactory.get());
            }
        }
    }
}

