/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;

public final class ArrayFunction {
    private ArrayFunction() {
    }

    @NonNull
    public static Expression contains(@NonNull Expression expression, @NonNull Expression value) {
        Preconditions.assertNotNull(expression, "expression");
        Preconditions.assertNotNull(value, "value");
        return new Expression.FunctionExpression("ARRAY_CONTAINS()", Arrays.asList(expression, value));
    }

    @NonNull
    public static Expression length(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new Expression.FunctionExpression("ARRAY_LENGTH()", Arrays.asList(expression));
    }
}

