/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.javascript;

import com.couchbase.lite.Reducer;
import com.couchbase.lite.javascript.scopes.ReduceGlobalScope;
import com.couchbase.lite.javascript.wrapper.CustomWrapFactory;
import com.couchbase.lite.util.Log;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

class ViewReduceBlockRhino
implements Reducer {
    private static final String TAG = "JavaScriptEngine";
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private final ReduceGlobalScope reduceGlobalScope;
    private final ScriptableObject globalScope;
    private final Function reduceFunction;
    private final NativReduceFunctions nativeReduce;
    private final Object lockFunction = new Object();

    public ViewReduceBlockRhino(String src) {
        this.nativeReduce = NativReduceFunctions.fromKey(src);
        if (this.nativeReduce == NativReduceFunctions.DEFAULT) {
            Context ctx = Context.enter();
            try {
                ctx.setOptimizationLevel(-1);
                ctx.setWrapFactory(wrapFactory);
                this.reduceGlobalScope = new ReduceGlobalScope();
                this.globalScope = ctx.initStandardObjects((ScriptableObject)this.reduceGlobalScope, true);
                this.reduceFunction = ctx.compileFunction((Scriptable)this.globalScope, src, "reduce", 0, null);
            }
            finally {
                Context.exit();
            }
        } else {
            this.reduceGlobalScope = null;
            this.globalScope = null;
            this.reduceFunction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce(List<Object> keys, List<Object> values, boolean reReduce) {
        switch (this.nativeReduce) {
            case SUM: {
                return ViewReduceBlockRhino.nativeSum(keys, values, reReduce);
            }
            case COUNT: {
                return ViewReduceBlockRhino.nativeCount(keys, values, reReduce);
            }
        }
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            Scriptable localScope = ctx.newObject((Scriptable)this.globalScope);
            localScope.setPrototype((Scriptable)this.globalScope);
            localScope.setParentScope(null);
            Object[] args = new Object[]{Context.javaToJS(keys, (Scriptable)localScope), Context.javaToJS(values, (Scriptable)localScope), Context.javaToJS((Object)reReduce, (Scriptable)localScope)};
            Object object = this.lockFunction;
            synchronized (object) {
                try {
                    Object object2 = this.reduceFunction.call(ctx, localScope, null, args);
                    return object2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RhinoException e) {
                        Log.e((String)TAG, (String)"Error in calling JavaScript reduce function", (Throwable)e);
                        Object var8_10 = null;
                        Context.exit();
                        return var8_10;
                    }
                }
            }
        }
        finally {
            Context.exit();
        }
    }

    private static double nativeSum(List<Object> keys, List<Object> values, boolean reReduce) {
        double sum = 0.0;
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            sum += new Double(String.valueOf(values.get(i))).doubleValue();
        }
        return sum;
    }

    private static double nativeCount(List<Object> keys, List<Object> values, boolean reReduce) {
        if (reReduce) {
            return ViewReduceBlockRhino.nativeSum(keys, values, reReduce);
        }
        return new Double(values.size());
    }

    static enum NativReduceFunctions {
        COUNT("_count"),
        SUM("_sum"),
        DEFAULT("default");

        private String mKey;

        private NativReduceFunctions(String key) {
            this.mKey = key;
        }

        public static NativReduceFunctions fromKey(String key) {
            if (key != null) {
                for (NativReduceFunctions type : NativReduceFunctions.values()) {
                    if (!key.equalsIgnoreCase(type.mKey)) continue;
                    return type;
                }
            }
            return DEFAULT;
        }

        public String getKey() {
            return this.mKey;
        }

        public String toString() {
            return this.mKey;
        }
    }
}

