/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.javascript;

import com.couchbase.lite.Emitter;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.javascript.scopes.MapGlobalScope;
import com.couchbase.lite.javascript.wrapper.CustomWrapFactory;
import com.couchbase.lite.util.Log;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

class ViewMapBlockRhino
implements Mapper {
    private static final String TAG = "JavaScriptEngine";
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private Scriptable globalScope;
    private MapGlobalScope mapGlobalScope;
    private Function mapFunction;
    private final Object lockFunction = new Object();

    public ViewMapBlockRhino(String src) {
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            this.mapGlobalScope = new MapGlobalScope();
            this.globalScope = ctx.initStandardObjects((ScriptableObject)this.mapGlobalScope, true);
            this.mapFunction = ctx.compileFunction(this.globalScope, src, "map", 0, null);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(Map<String, Object> document, Emitter emitter) {
        this.mapGlobalScope.setEmitter(emitter);
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            Scriptable localScope = ctx.newObject(this.globalScope);
            localScope.setPrototype(this.globalScope);
            localScope.setParentScope(null);
            Object jsDocument = Context.javaToJS(document, (Scriptable)localScope);
            try {
                Object object = this.lockFunction;
                synchronized (object) {
                    this.mapFunction.call(ctx, localScope, null, new Object[]{jsDocument});
                }
            }
            catch (RhinoException e) {
                Log.e((String)TAG, (String)"Error in calling JavaScript map function", (Throwable)e);
                Context.exit();
                return;
            }
        }
        finally {
            Context.exit();
        }
    }
}

