/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.Headers;
import okhttp3.Response;

public class Utils {
    public static int DEFAULT_TIME_TO_WAIT_4_SHUTDOWN = 20;
    public static int DEFAULT_TIME_TO_WAIT_4_SHUTDOWNNOW = 20;
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();
    public static int CHUNK_SIZE = 8192;

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj2 != null && obj1.equals(obj2);
        }
        return obj2 == null;
    }

    public static boolean isPermanentError(Throwable throwable) {
        if (throwable instanceof CouchbaseLiteException) {
            CouchbaseLiteException e = (CouchbaseLiteException)throwable;
            return Utils.isPermanentError(e.getCBLStatus().getCode());
        }
        if (throwable instanceof RemoteRequestResponseException) {
            RemoteRequestResponseException e = (RemoteRequestResponseException)throwable;
            return Utils.isPermanentError(e.getCode());
        }
        return false;
    }

    public static boolean isPermanentError(Response response) {
        return Utils.isPermanentError(response.code());
    }

    public static boolean isPermanentError(int code) {
        if (code == RemoteRequestResponseException.BAD_URL || code == RemoteRequestResponseException.USER_DENIED_AUTH) {
            return true;
        }
        return code >= 400 && code <= 407 || code >= 409 && code <= 499;
    }

    public static boolean isTransientError(Throwable throwable) {
        if (throwable instanceof CouchbaseLiteException) {
            CouchbaseLiteException e = (CouchbaseLiteException)throwable;
            return Utils.isTransientError(e.getCBLStatus().getCode());
        }
        if (throwable instanceof RemoteRequestResponseException) {
            RemoteRequestResponseException e = (RemoteRequestResponseException)throwable;
            return Utils.isTransientError(e.getCode());
        }
        if (throwable instanceof SocketTimeoutException) {
            return true;
        }
        if (throwable instanceof ConnectException) {
            return true;
        }
        if (throwable instanceof SocketException) {
            return true;
        }
        return throwable instanceof IOException;
    }

    public static boolean isTransientError(Response response) {
        return Utils.isTransientError(response.code());
    }

    public static boolean isTransientError(int code) {
        return code == 408 || code == 500 || code == 502 || code == 503 || code == 504;
    }

    public static boolean isDocumentError(Throwable throwable) {
        if (throwable instanceof CouchbaseLiteException) {
            CouchbaseLiteException e = (CouchbaseLiteException)throwable;
            return Utils.isDocumentError(e.getCBLStatus().getCode());
        }
        if (throwable instanceof RemoteRequestResponseException) {
            RemoteRequestResponseException e = (RemoteRequestResponseException)throwable;
            return Utils.isDocumentError(e.getCode());
        }
        return false;
    }

    public static boolean isDocumentError(int statusCode) {
        return statusCode == 404 || statusCode == 403 || statusCode == 410;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void assertNotNull(Object o, String errMsg) {
        if (o == null) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    @InterfaceAudience.Private
    public static boolean is404(Throwable e) {
        if (e instanceof RemoteRequestResponseException) {
            return ((RemoteRequestResponseException)e).getCode() == 404;
        }
        return false;
    }

    @InterfaceAudience.Private
    public static int getStatusFromError(Throwable t) {
        if (t instanceof CouchbaseLiteException) {
            CouchbaseLiteException couchbaseLiteException = (CouchbaseLiteException)t;
            return couchbaseLiteException.getCBLStatus().getCode();
        }
        if (t instanceof RemoteRequestResponseException) {
            RemoteRequestResponseException responseException = (RemoteRequestResponseException)t;
            return responseException.getCode();
        }
        return -1;
    }

    @InterfaceAudience.Private
    public static String getErrorMessageFromError(Throwable t) {
        if (t instanceof CouchbaseLiteException) {
            CouchbaseLiteException couchbaseLiteException = (CouchbaseLiteException)t;
            return couchbaseLiteException.getCBLStatus().getHTTPMessage();
        }
        if (t instanceof RemoteRequestResponseException) {
            RemoteRequestResponseException responseException = (RemoteRequestResponseException)t;
            return responseException.getMessage();
        }
        return t.getMessage();
    }

    public static String shortenString(String orig, int maxLength) {
        if (orig == null || orig.length() <= maxLength) {
            return orig;
        }
        return orig.substring(0, maxLength);
    }

    public static boolean isGzip(Response response) {
        return Utils.isGzip(response.header("Content-Encoding"));
    }

    public static boolean isGzip(String contentEncoding) {
        return contentEncoding != null && contentEncoding.contains("gzip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressByGzip(byte[] sourceBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = null;
            try {
                gzip = new GZIPOutputStream(out);
                gzip.write(sourceBytes);
                gzip.close();
            }
            catch (IOException ex) {
                byte[] byArray = null;
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return byArray;
            }
            finally {
                try {
                    if (gzip != null) {
                        gzip.close();
                    }
                }
                catch (IOException iOException) {}
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompressByGzip(byte[] sourceBytes) {
        byte[] buffer = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            buffer = new byte[CHUNK_SIZE];
            in = new ByteArrayInputStream(sourceBytes);
            gzip = new GZIPInputStream(in);
            int len = 0;
            while ((len = gzip.read(buffer, 0, CHUNK_SIZE)) != -1) {
                out.write(buffer, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            Log.w("CBLite", "Failed to decompress gzipped data: " + ex.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (gzip != null) {
                    gzip.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, String> headersToMap(Headers headers) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String name : headers.names()) {
            map.put(name, headers.get(name));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeToWait4ShutDown, long timeToWait4ShutDownNow) {
        block12: {
            ExecutorService executorService = pool;
            synchronized (executorService) {
                pool.shutdown();
            }
            try {
                if (pool.awaitTermination(timeToWait4ShutDown, TimeUnit.SECONDS)) break block12;
                executorService = pool;
                synchronized (executorService) {
                    pool.shutdownNow();
                }
                if (!pool.awaitTermination(timeToWait4ShutDownNow, TimeUnit.SECONDS)) {
                    Log.e("Database", "Pool did not terminate");
                }
            }
            catch (InterruptedException ie) {
                ExecutorService executorService2 = pool;
                synchronized (executorService2) {
                    pool.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        Utils.shutdownAndAwaitTermination(pool, DEFAULT_TIME_TO_WAIT_4_SHUTDOWN, DEFAULT_TIME_TO_WAIT_4_SHUTDOWNNOW);
    }
}

