/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class URLUtils {
    public static Map<String, List<String>> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = url.getQuery().split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }

    public static String getUser(URL url) {
        if (url == null || url.getUserInfo() == null) {
            return null;
        }
        String[] tokens = url.getUserInfo().split(":");
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        return tokens[0];
    }
}

