/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.internal.InterfaceAudience;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class TextUtils {
    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream is) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int numRead;
            byte[] bytes = new byte[512];
            int offset = 0;
            while ((numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                buffer.write(bytes, 0, numRead);
                offset += numRead;
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            buffer.close();
        }
    }

    public static String read(File file) throws IOException {
        byte[] content = null;
        FileInputStream input = new FileInputStream(file);
        try {
            content = TextUtils.read(input);
        }
        finally {
            ((InputStream)input).close();
        }
        return content != null ? new String(content) : null;
    }

    public static void write(String text, File file) throws IOException {
        FilterOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            output.write(text.getBytes());
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    @InterfaceAudience.Private
    public static String joinQuoted(List<String> strings) {
        if (strings.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("'");
        boolean first = true;
        for (String string : strings) {
            if (first) {
                first = false;
            } else {
                result.append("','");
            }
            result.append(TextUtils.quote(string));
        }
        result.append('\'');
        return result.toString();
    }

    @InterfaceAudience.Private
    public static String joinQuotedObjects(List<Object> objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object object : objects) {
            strings.add(object != null ? object.toString() : null);
        }
        return TextUtils.joinQuoted(strings);
    }

    public static String quote(String string) {
        return string.replace("'", "''");
    }
}

