/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class StreamUtils {
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[16384];
        while ((n = is.read(buffer)) > -1) {
            os.write(buffer, 0, n);
        }
        os.close();
        is.close();
    }

    public static void copyStreamsToFolder(Iterator<Map.Entry<String, InputStream>> streams, File folder) throws IOException {
        while (streams.hasNext()) {
            Map.Entry<String, InputStream> entry = streams.next();
            File file = new File(folder, entry.getKey());
            StreamUtils.copyStreamToFile(entry.getValue(), file);
        }
    }

    public static void copyStreamToFile(InputStream is, File file) throws IOException {
        int n;
        FileOutputStream os = new FileOutputStream(file);
        byte[] buffer = new byte[16384];
        while ((n = is.read(buffer)) > -1) {
            ((OutputStream)os).write(buffer, 0, n);
        }
        ((OutputStream)os).close();
        is.close();
    }
}

