/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

public class RefCounter {
    private int refCount = 0;

    public synchronized void retain() {
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0) {
            throw new IllegalStateException("Reference counter is set to zero -- cannot release!");
        }
        if (--this.refCount == 0) {
            this.notifyAll();
        }
    }

    public synchronized int count() {
        return this.refCount;
    }

    public synchronized void await() {
        while (this.count() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

