/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.util.List;
import java.util.Map;

public class JSONUtils {
    private static long kObjectOverhead = 20L;

    public static long estimate(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof String) {
            return kObjectOverhead + (long)(2 * ((String)obj).length());
        }
        if (obj instanceof Number) {
            return kObjectOverhead + 8L;
        }
        if (obj instanceof Map) {
            long size = kObjectOverhead;
            Map map = (Map)obj;
            for (Object key : map.keySet()) {
                size += JSONUtils.estimate(key) + JSONUtils.estimate(map.get(key));
            }
            return size;
        }
        if (obj instanceof List) {
            long size = kObjectOverhead;
            for (Object item : (List)obj) {
                size += JSONUtils.estimate(item);
            }
            return size;
        }
        return 0L;
    }
}

