/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class DeepClone {
    private DeepClone() {
    }

    public static <T> T deepClone(T input) {
        if (input == null) {
            return input;
        }
        if (input instanceof Map) {
            return (T)DeepClone.deepCloneMap((Map)input);
        }
        if (input instanceof Collection) {
            return (T)DeepClone.deepCloneCollection((Collection)input);
        }
        if (input instanceof Object[]) {
            return (T)DeepClone.deepCloneObjectArray((Object[])input);
        }
        return input;
    }

    private static Object clonePrimitiveArray(Object input) {
        int length = Array.getLength(input);
        Object copy = Array.newInstance(input.getClass().getComponentType(), length);
        System.arraycopy(input, 0, copy, 0, length);
        return copy;
    }

    private static <E> E[] deepCloneObjectArray(E[] input) {
        Object[] clone = (Object[])Array.newInstance(input.getClass().getComponentType(), input.length);
        for (int i = 0; i < input.length; ++i) {
            clone[i] = DeepClone.deepClone(input[i]);
        }
        return clone;
    }

    private static <E> Collection<E> deepCloneCollection(Collection<E> input) {
        AbstractCollection clone = input instanceof ArrayList ? new ArrayList() : (input instanceof LinkedList ? new LinkedList() : (input instanceof SortedSet ? new TreeSet() : (input instanceof Set ? new HashSet() : new ArrayList())));
        for (E item : input) {
            clone.add(DeepClone.deepClone(item));
        }
        return clone;
    }

    private static <K, V> Map<K, V> deepCloneMap(Map<K, V> map) {
        TreeMap<K, V> clone = new TreeMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), DeepClone.deepClone(entry.getValue()));
        }
        return clone;
    }
}

