/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.util.ArrayList;
import java.util.Collection;

public class CollectionUtils {
    public static <T> Collection<T> filter(Collection<T> target, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : target) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T, U> Collection<U> transform(Collection<T> target, Functor<T, U> functor) {
        ArrayList<U> result = new ArrayList<U>();
        for (T element : target) {
            U mapped = functor.invoke(element);
            if (mapped == null) continue;
            result.add(mapped);
        }
        return result;
    }

    public static interface Functor<T, U> {
        public U invoke(T var1);
    }

    public static interface Predicate<T> {
        public boolean apply(T var1);
    }
}

