/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support.action;

import com.couchbase.lite.Misc;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.support.action.ActionBlock;
import com.couchbase.lite.support.action.ActionException;
import com.couchbase.lite.support.action.AtomicAction;
import com.couchbase.lite.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Action
implements AtomicAction {
    private List<ActionBlock> peforms = new ArrayList<ActionBlock>();
    private List<ActionBlock> backouts = new ArrayList<ActionBlock>();
    private List<ActionBlock> cleanUps = new ArrayList<ActionBlock>();
    private int nextStep = 0;
    private Exception lastError;
    private int failedStep;
    private static ActionBlock nullAction = new ActionBlock(){

        @Override
        public void execute() throws ActionException {
        }
    };

    public Action() {
    }

    public Action(ActionBlock perform, ActionBlock backout, ActionBlock cleanup) {
        this();
        this.add(perform, backout, cleanup);
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public int getFailedStep() {
        return this.failedStep;
    }

    public void add(final AtomicAction action) {
        if (action instanceof Action) {
            Action a = (Action)action;
            this.peforms.addAll(a.peforms);
            this.backouts.addAll(a.backouts);
            this.cleanUps.addAll(a.cleanUps);
        } else {
            this.add(new ActionBlock(){

                @Override
                public void execute() throws ActionException {
                    action.perform();
                }
            }, new ActionBlock(){

                @Override
                public void execute() throws ActionException {
                    action.backout();
                }
            }, new ActionBlock(){

                @Override
                public void execute() throws ActionException {
                    action.cleanup();
                }
            });
        }
    }

    public void add(ActionBlock perform, ActionBlock backout, ActionBlock cleanup) {
        this.peforms.add(perform != null ? perform : nullAction);
        this.backouts.add(backout != null ? backout : nullAction);
        this.cleanUps.add(cleanup != null ? cleanup : nullAction);
    }

    public void add(ActionBlock perform, ActionBlock backoutOrCleanup) {
        this.add(perform, backoutOrCleanup, backoutOrCleanup);
    }

    public void run() throws ActionException {
        try {
            this.perform();
            try {
                this.cleanup();
            }
            catch (ActionException actionException) {
                // empty catch block
            }
            this.lastError = null;
        }
        catch (ActionException e) {
            this.lastError = e;
            throw e;
        }
    }

    @Override
    public void perform() throws ActionException {
        if (this.nextStep > 0) {
            throw new IllegalStateException("Actions have already been run");
        }
        this.failedStep = -1;
        while (this.nextStep < this.peforms.size()) {
            try {
                this.doAction(this.peforms);
            }
            catch (ActionException e) {
                this.failedStep = this.nextStep;
                if (this.nextStep > 0) {
                    try {
                        this.backout();
                    }
                    catch (ActionException actionException) {
                        // empty catch block
                    }
                }
                throw e;
            }
            ++this.nextStep;
        }
    }

    @Override
    public void backout() throws ActionException {
        if (this.nextStep == 0) {
            throw new IllegalStateException("Actions have not been run");
        }
        while (this.nextStep-- > 0) {
            try {
                this.doAction(this.backouts);
            }
            catch (ActionException e) {
                Log.e("Action", "Error backing out step: " + this.nextStep, e);
                throw e;
            }
        }
    }

    @Override
    public void cleanup() throws ActionException {
        if (this.nextStep != this.peforms.size()) {
            throw new IllegalStateException("Actions did not all run");
        }
        while (this.nextStep-- > 0) {
            try {
                this.doAction(this.cleanUps);
            }
            catch (ActionException e) {
                Log.e("Action", "Error cleaning up step: " + this.nextStep, e);
                throw e;
            }
        }
    }

    private void doAction(List<ActionBlock> actions) throws ActionException {
        try {
            actions.get(this.nextStep).execute();
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionException("Exception raised by step: " + this.nextStep, e);
        }
    }

    public static Action deleteFile(final String path, String tempDir) {
        if (path == null) {
            throw new IllegalArgumentException("The path variable cannot be null");
        }
        if (tempDir == null) {
            throw new IllegalArgumentException("The tempDir variable cannot be null");
        }
        final File tempFile = new File(tempDir, Misc.CreateUUID());
        final AtomicBoolean exists = new AtomicBoolean();
        return new Action(new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                File file = new File(path);
                if (file.exists()) {
                    if (tempFile == null) {
                        throw new ActionException("Cannot perform file deletion as the temporary file cannot be crated.");
                    }
                    boolean success = new File(path).renameTo(tempFile);
                    exists.set(success);
                    if (success) {
                        tempFile.deleteOnExit();
                    } else {
                        throw new ActionException("Cannot move file " + path + " to " + tempFile.getAbsolutePath());
                    }
                }
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                if (exists.get() && !tempFile.renameTo(new File(path))) {
                    throw new ActionException("Cannot move file " + tempFile.getAbsolutePath() + " to " + path);
                }
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                if (exists.get()) {
                    if (tempFile.isDirectory()) {
                        if (!FileDirUtils.deleteRecursive(tempFile)) {
                            throw new ActionException("Cannot delete the temporary directory " + tempFile.getAbsolutePath());
                        }
                    } else if (!tempFile.delete()) {
                        throw new ActionException("Cannot delete the temporary file " + tempFile.getAbsolutePath());
                    }
                }
            }
        });
    }

    public static Action moveFileToEmptyPath(final String srcPath, final String destPath) {
        if (srcPath == null) {
            throw new IllegalArgumentException("The srcPath variable cannot be null");
        }
        if (destPath == null) {
            throw new IllegalArgumentException("The destPath variable cannot be null");
        }
        return new Action(new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                File destFile = new File(destPath);
                if (destFile.exists()) {
                    throw new ActionException("Cannot move file. The Destination file " + destPath + " already exists.");
                }
                boolean success = new File(srcPath).renameTo(destFile);
                if (!success) {
                    throw new ActionException("Cannot move file " + srcPath + " to " + destPath);
                }
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                boolean success = new File(destPath).renameTo(new File(srcPath));
                if (!success) {
                    throw new ActionException("Cannot move file " + destPath + " to " + srcPath);
                }
            }
        }, null);
    }

    public static Action moveAndReplaceFile(String srcPath, String destPath, String tempDir) {
        Action seq = new Action();
        seq.add(Action.deleteFile(destPath, tempDir));
        seq.add(Action.moveFileToEmptyPath(srcPath, destPath));
        return seq;
    }
}

