/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.CustomByteArrayOutputStream;
import com.couchbase.lite.support.KMPMatch;
import com.couchbase.lite.support.MultipartReaderDelegate;
import com.couchbase.lite.support.Range;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class MultipartReader {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final byte[] kCRLFCRLF = "\r\n\r\n".getBytes(utf8);
    private static final byte[] kEOM = "--".getBytes(utf8);
    private MultipartReaderState state = null;
    private CustomByteArrayOutputStream buffer = null;
    private String contentType = null;
    private byte[] boundary = null;
    private byte[] boundaryWithoutLeadingCRLF = null;
    private MultipartReaderDelegate delegate = null;
    public Map<String, String> headers = null;

    public MultipartReader(String contentType, MultipartReaderDelegate delegate) {
        this.contentType = contentType;
        this.delegate = delegate;
        this.buffer = new CustomByteArrayOutputStream(1024);
        this.state = MultipartReaderState.kAtStart;
        this.parseContentType();
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    public byte[] getBoundaryWithoutLeadingCRLF() {
        if (this.boundaryWithoutLeadingCRLF == null) {
            byte[] rawBoundary = this.getBoundary();
            this.boundaryWithoutLeadingCRLF = Arrays.copyOfRange(rawBoundary, 2, rawBoundary.length);
        }
        return this.boundaryWithoutLeadingCRLF;
    }

    public boolean finished() {
        return this.state == MultipartReaderState.kAtEnd;
    }

    private static boolean memcmp(byte[] array1, byte[] array2, int len) {
        boolean equals = true;
        for (int i = 0; i < len; ++i) {
            if (array1[i] == array2[i]) continue;
            equals = false;
        }
        return equals;
    }

    public Range searchFor(byte[] pattern, int start) {
        KMPMatch searcher = new KMPMatch();
        int matchIndex = searcher.indexOf(this.buffer.buf(), this.buffer.count(), pattern, start);
        if (matchIndex != -1) {
            return new Range(matchIndex, pattern.length);
        }
        return new Range(matchIndex, 0);
    }

    public void parseHeaders(String headersStr) {
        this.headers = new HashMap<String, String>();
        if (headersStr != null && headersStr.length() > 0) {
            headersStr = headersStr.trim();
            StringTokenizer tokenizer = new StringTokenizer(headersStr, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String header = tokenizer.nextToken();
                if (!header.contains(":")) {
                    throw new IllegalArgumentException("Missing ':' in header line: " + header);
                }
                int colon = header.indexOf(58);
                String key = header.substring(0, colon).trim();
                String value = header.substring(colon + 1).trim();
                this.headers.put(key, value);
            }
        }
    }

    private void deleteUpThrough(int location) {
        if (location <= 0) {
            return;
        }
        byte[] b = this.buffer.toByteArray();
        this.buffer.reset();
        this.buffer.write(b, location, b.length - location);
    }

    private void trimBuffer() {
        int boundaryLen;
        int bufLen = this.buffer.count();
        if (bufLen > (boundaryLen = this.getBoundary().length)) {
            this.delegate.appendToPart(this.buffer.buf(), 0, bufLen - boundaryLen);
            this.deleteUpThrough(bufLen - boundaryLen);
        }
    }

    public void appendData(byte[] data) {
        this.appendData(data, 0, data.length);
    }

    public void appendData(byte[] data, int off, int len) {
        MultipartReaderState nextState;
        if (this.buffer == null) {
            return;
        }
        if (len == 0) {
            return;
        }
        this.buffer.write(data, off, len);
        do {
            nextState = MultipartReaderState.kUninitialized;
            int bufLen = this.buffer.count();
            switch (this.state) {
                case kAtStart: {
                    byte[] boundaryWithoutLeadingCRLF = this.getBoundaryWithoutLeadingCRLF();
                    if (bufLen < boundaryWithoutLeadingCRLF.length) break;
                    if (MultipartReader.memcmp(this.buffer.buf(), boundaryWithoutLeadingCRLF, boundaryWithoutLeadingCRLF.length)) {
                        this.deleteUpThrough(boundaryWithoutLeadingCRLF.length);
                        nextState = MultipartReaderState.kInHeaders;
                        break;
                    }
                    nextState = MultipartReaderState.kInPrologue;
                    break;
                }
                case kInPrologue: 
                case kInBody: {
                    if (bufLen < this.boundary.length) break;
                    int start = Math.max(0, bufLen - data.length - this.boundary.length);
                    Range r = this.searchFor(this.boundary, start);
                    if (r.getLength() > 0) {
                        if (this.state == MultipartReaderState.kInBody) {
                            this.delegate.appendToPart(this.buffer.buf(), 0, r.getLocation());
                            this.delegate.finishedPart();
                        }
                        this.deleteUpThrough(r.getLocation() + r.getLength());
                        nextState = MultipartReaderState.kInHeaders;
                        break;
                    }
                    this.trimBuffer();
                    break;
                }
                case kInHeaders: {
                    if (bufLen >= kEOM.length && MultipartReader.memcmp(this.buffer.buf(), kEOM, kEOM.length)) {
                        this.state = MultipartReaderState.kAtEnd;
                        this.close();
                        return;
                    }
                    Range r = this.searchFor(kCRLFCRLF, 0);
                    if (r.getLength() <= 0) break;
                    String headersString = new String(this.buffer.buf(), 0, r.getLocation(), utf8);
                    this.parseHeaders(headersString);
                    this.deleteUpThrough(r.getLocation() + r.getLength());
                    this.delegate.startedPart(this.headers);
                    nextState = MultipartReaderState.kInBody;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected data after end of MIME body");
                }
            }
            if (nextState == MultipartReaderState.kUninitialized) continue;
            this.state = nextState;
        } while (nextState != MultipartReaderState.kUninitialized && this.buffer.count() > 0);
    }

    private void close() {
        if (this.buffer != null) {
            try {
                this.buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.buffer = null;
        this.boundary = null;
        this.boundaryWithoutLeadingCRLF = null;
    }

    private void parseContentType() {
        StringTokenizer tokenizer = new StringTokenizer(this.contentType, ";");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String param = tokenizer.nextToken().trim();
            if (first) {
                if (!param.startsWith("multipart/")) {
                    throw new IllegalArgumentException(this.contentType + " does not start with multipart/");
                }
                first = false;
                continue;
            }
            if (!param.startsWith("boundary=")) continue;
            String tempBoundary = param.substring(9);
            if (tempBoundary.startsWith("\"")) {
                if (tempBoundary.length() < 2 || !tempBoundary.endsWith("\"")) {
                    throw new IllegalArgumentException(this.contentType + " is not valid");
                }
                tempBoundary = tempBoundary.substring(1, tempBoundary.length() - 1);
            }
            if (tempBoundary.length() < 1) {
                throw new IllegalArgumentException(this.contentType + " has zero-length boundary");
            }
            tempBoundary = String.format(Locale.ENGLISH, "\r\n--%s", tempBoundary);
            this.boundary = tempBoundary.getBytes(Charset.forName("UTF-8"));
            break;
        }
    }

    private static enum MultipartReaderState {
        kUninitialized,
        kAtStart,
        kInPrologue,
        kInBody,
        kInHeaders,
        kAtEnd,
        kFailed;

    }
}

