/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.BlockingQueueListener;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class CustomLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private BlockingQueueListener listener = null;

    public CustomLinkedBlockingQueue() {
    }

    public CustomLinkedBlockingQueue(BlockingQueueListener listener) {
        this.listener = listener;
    }

    public CustomLinkedBlockingQueue(int capacity) {
        super(capacity);
    }

    public CustomLinkedBlockingQueue(Collection c) {
        super(c);
    }

    public BlockingQueueListener getListener() {
        return this.listener;
    }

    public void setListener(BlockingQueueListener listener) {
        this.listener = listener;
    }

    @Override
    public void put(E e) throws InterruptedException {
        super.put(e);
        if (this.listener != null) {
            this.listener.changed(BlockingQueueListener.EventType.PUT, e, this);
        }
    }

    @Override
    public boolean add(E e) {
        boolean b = super.add(e);
        if (this.listener != null) {
            this.listener.changed(BlockingQueueListener.EventType.ADD, e, this);
        }
        return b;
    }

    @Override
    public E take() throws InterruptedException {
        Object e = super.take();
        if (this.listener != null) {
            this.listener.changed(BlockingQueueListener.EventType.TAKE, e, this);
        }
        return e;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = super.poll(timeout, unit);
        if (this.listener != null) {
            this.listener.changed(BlockingQueueListener.EventType.POLL, e, this);
        }
        return e;
    }

    @Override
    public E poll() {
        Object e = super.poll();
        if (this.listener != null) {
            this.listener.changed(BlockingQueueListener.EventType.POLL, e, this);
        }
        return e;
    }
}

