/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.support.ClearableCookieJar;
import com.couchbase.lite.support.HttpClientFactory;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class CouchbaseLiteHttpClientFactory
implements HttpClientFactory {
    private OkHttpClient client;
    private ClearableCookieJar cookieJar;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean followRedirects = true;
    public static int DEFAULT_SO_TIMEOUT_SECONDS = 40;
    public static int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 10;
    public static int DEFAULT_READ_TIMEOUT = DEFAULT_SO_TIMEOUT_SECONDS;
    public static int DEFAULT_WRITE_TIMEOUT = 10;

    public CouchbaseLiteHttpClientFactory(ClearableCookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    @InterfaceAudience.Private
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (this.sslSocketFactory != null) {
            throw new RuntimeException("SSLSocketFactory is already set");
        }
        this.sslSocketFactory = sslSocketFactory;
    }

    @InterfaceAudience.Private
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (this.hostnameVerifier != null) {
            throw new RuntimeException("HostnameVerifier is already set");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    @InterfaceAudience.Private
    public synchronized OkHttpClient getOkHttpClient() {
        if (this.client == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout((long)DEFAULT_CONNECTION_TIMEOUT_SECONDS, TimeUnit.SECONDS).writeTimeout((long)DEFAULT_WRITE_TIMEOUT, TimeUnit.SECONDS).readTimeout((long)DEFAULT_READ_TIMEOUT, TimeUnit.SECONDS);
            if (this.sslSocketFactory != null) {
                builder.sslSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                builder.hostnameVerifier(this.hostnameVerifier);
            }
            builder.cookieJar((CookieJar)this.cookieJar);
            if (!this.isFollowRedirects()) {
                builder.followRedirects(false);
            }
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void addCookies(List<Cookie> cookies) {
        if (this.cookieJar != null) {
            this.cookieJar.saveFromResponse(null, cookies);
        }
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void deleteCookie(String name) {
        if (this.cookieJar == null) {
            return;
        }
        List cookies = this.cookieJar.loadForRequest(null);
        ArrayList<Cookie> retainedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (cookie.name().equals(name)) continue;
            retainedCookies.add(cookie);
        }
        this.cookieJar.clear();
        this.cookieJar.saveFromResponse(null, retainedCookies);
    }

    private static boolean isMatch(Cookie cookie, URL url) {
        return cookie.matches(HttpUrl.get((URL)url));
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void deleteCookie(URL url) {
        if (this.cookieJar == null) {
            return;
        }
        List cookies = this.cookieJar.loadForRequest(null);
        ArrayList<Cookie> retainedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (cookie.matches(HttpUrl.get((URL)url))) continue;
            retainedCookies.add(cookie);
        }
        this.cookieJar.clear();
        this.cookieJar.saveFromResponse(null, retainedCookies);
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void resetCookieStore() {
        if (this.cookieJar == null) {
            return;
        }
        this.cookieJar.clear();
    }

    @Override
    @InterfaceAudience.Private
    public CookieJar getCookieStore() {
        return this.cookieJar;
    }

    private static SSLSocketFactory selfSignedSSLSocketFactory() throws GeneralSecurityException {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return sslContext.getSocketFactory();
    }

    private static HostnameVerifier ignoreHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    @InterfaceAudience.Public
    public void allowSelfSignedSSLCertificates() {
        try {
            this.setSSLSocketFactory(CouchbaseLiteHttpClientFactory.selfSignedSSLSocketFactory());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.setHostnameVerifier(CouchbaseLiteHttpClientFactory.ignoreHostnameVerifier());
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }
}

