/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.storage;

import com.couchbase.lite.internal.database.ContentValues;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.support.security.SymmetricKey;

public interface SQLiteStorageEngine {
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;

    public boolean open(String var1, SymmetricKey var2) throws SQLException;

    public int getVersion();

    public void setVersion(int var1);

    public boolean isOpen();

    public void beginTransaction();

    public void endTransaction();

    public void setTransactionSuccessful();

    public void execSQL(String var1) throws SQLException;

    public void execSQL(String var1, Object[] var2) throws SQLException;

    public Cursor rawQuery(String var1, String[] var2);

    public long insert(String var1, String var2, ContentValues var3);

    public long insertOrThrow(String var1, String var2, ContentValues var3) throws SQLException;

    public long insertWithOnConflict(String var1, String var2, ContentValues var3, int var4);

    public int update(String var1, ContentValues var2, String var3, String[] var4);

    public int delete(String var1, String var2, String[] var3);

    public void close();

    public boolean supportEncryption();

    public byte[] derivePBKDF2SHA256Key(String var1, byte[] var2, int var3);
}

