/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

import com.couchbase.lite.router.BufferOutputStream;
import com.couchbase.lite.router.ByteBuffer;
import java.io.IOException;
import java.io.InputStream;

public class BufferInputStream
extends InputStream {
    private BufferOutputStream os;

    public BufferInputStream(BufferOutputStream os) {
        this.os = os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.os.getBuffer();
        synchronized (byteBuffer) {
            while (buffer.isEmpty()) {
                if (this.os.isClosed()) {
                    return -1;
                }
                try {
                    buffer.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return buffer.pop().byteValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        ByteBuffer buffer;
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset + length > bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not be negative");
        }
        ByteBuffer byteBuffer = buffer = this.os.getBuffer();
        synchronized (byteBuffer) {
            while (buffer.isEmpty()) {
                if (this.os.isClosed()) {
                    return -1;
                }
                try {
                    buffer.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.os.getBuffer().pop(bytes, offset, length);
        }
    }
}

