/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.replicator.RemoteMultipartDownloaderRequest;
import com.couchbase.lite.replicator.RemoteMultipartRequest;
import com.couchbase.lite.replicator.RemoteRequest;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.support.CustomFuture;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.util.CancellableRunnable;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Response;

public class RemoteRequestRetry<T>
implements CustomFuture<T> {
    public static final String TAG = "RemoteRequest";
    public static int MAX_RETRIES = 3;
    public static int RETRY_DELAY_MS = 4000;
    protected ScheduledExecutorService workExecutor;
    protected ExecutorService requestExecutor;
    protected final HttpClientFactory clientFactory;
    protected String method;
    protected URL url;
    protected Map<String, Object> body;
    protected Map<String, Object> attachments;
    protected Authenticator authenticator;
    protected RemoteRequestCompletion onCompletionCaller;
    protected RemoteRequestCompletion onPreCompletionCaller;
    private int retryCount;
    private Database db;
    private AtomicBoolean completed = new AtomicBoolean(false);
    private Response requestHttpResponse;
    private Object requestResult;
    private Throwable requestThrowable;
    private BlockingQueue<Future> pendingRequests;
    Map<Future, CancellableRunnable> runnables = new HashMap<Future, CancellableRunnable>();
    private boolean syncGateway = true;
    private boolean cancelable = true;
    private boolean dontLog404;
    protected Map<String, Object> requestHeaders;
    private RemoteRequestType requestType;
    ScheduledFuture retryFuture;
    private Queue queue;
    private RemoteRequestCompletion onCompletionInner = new RemoteRequestCompletion(){

        @Override
        public void onCompletion(Response response, Object result, Throwable e) {
            Log.d(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry inner request finished, url: %s", this, RemoteRequestRetry.this.url);
            if (e == null) {
                Log.d(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry was successful, calling callback url: %s", this, RemoteRequestRetry.this.url);
                this.completed(response, result, e);
            } else if (RemoteRequestRetry.this.isTransientError(response, e)) {
                if (RemoteRequestRetry.this.requestExecutor != null && RemoteRequestRetry.this.requestExecutor.isShutdown()) {
                    Log.e(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry failed, RequestExecutor was shutdown. url: %s", this, RemoteRequestRetry.this.url);
                    this.completed(response, result, e);
                } else if (RemoteRequestRetry.this.retryCount >= MAX_RETRIES) {
                    Log.d(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry failed, but transient error.  retries exhausted. url: %s", this, RemoteRequestRetry.this.url);
                    this.completed(response, result, e);
                } else {
                    Log.d(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry failed, but transient error.  will retry. url: %s", this, RemoteRequestRetry.this.url);
                    RemoteRequestRetry.this.requestHttpResponse = response;
                    RemoteRequestRetry.this.requestResult = result;
                    RemoteRequestRetry.this.requestThrowable = e;
                    RemoteRequestRetry.this.retryCount = RemoteRequestRetry.this.retryCount + 1;
                    long delay = (long)RETRY_DELAY_MS * (long)Math.pow(2.0, Math.min(RemoteRequestRetry.this.retryCount - 1, MAX_RETRIES));
                    RemoteRequestRetry.this.retryFuture = RemoteRequestRetry.this.workExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            RemoteRequestRetry.this.submit();
                        }
                    }, delay, TimeUnit.MILLISECONDS);
                }
            } else {
                Log.d(RemoteRequestRetry.TAG, "%s: RemoteRequestRetry failed, non-transient error.  NOT retrying. url: %s", this, RemoteRequestRetry.this.url);
                this.completed(response, result, e);
            }
        }

        private void completed(Response response, Object result, Throwable e) {
            RemoteRequestRetry.this.requestHttpResponse = response;
            RemoteRequestRetry.this.requestResult = result;
            RemoteRequestRetry.this.requestThrowable = e;
            RemoteRequestRetry.this.onCompletionCaller.onCompletion(RemoteRequestRetry.this.requestHttpResponse, RemoteRequestRetry.this.requestResult, RemoteRequestRetry.this.requestThrowable);
            RemoteRequestRetry.this.requestHttpResponse = null;
            RemoteRequestRetry.this.requestResult = null;
            RemoteRequestRetry.this.requestThrowable = null;
            RemoteRequestRetry.this.removeFromQueue();
            RemoteRequestRetry.this.completed.set(true);
        }
    };

    public RemoteRequestRetry(RemoteRequestType requestType, ScheduledExecutorService requestExecutor, ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, boolean syncGateway, boolean cancelable, Map<String, Object> body, Map<String, Object> attachments, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletion onCompletionCaller) {
        this.requestType = requestType;
        this.requestExecutor = requestExecutor;
        this.clientFactory = clientFactory;
        this.method = method;
        this.url = url;
        this.syncGateway = syncGateway;
        this.cancelable = cancelable;
        this.body = body;
        this.attachments = attachments;
        this.onCompletionCaller = onCompletionCaller;
        this.workExecutor = workExecutor;
        this.requestHeaders = requestHeaders;
        this.db = db;
        this.pendingRequests = new LinkedBlockingQueue<Future>();
        Log.v(TAG, "%s: RemoteRequestRetry created, url: %s", this, url);
    }

    public CustomFuture submit() {
        return this.submit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFuture submit(boolean gzip) {
        RemoteRequest request = this.generateRemoteRequest();
        if (gzip) {
            request.setCompressedRequest(true);
        }
        ExecutorService executorService = this.requestExecutor;
        synchronized (executorService) {
            if (!this.requestExecutor.isShutdown()) {
                Future<?> future = this.requestExecutor.submit(request);
                this.pendingRequests.add(future);
                this.runnables.put(future, request);
            }
        }
        return this;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setOnPreCompletionCaller(RemoteRequestCompletion onPreCompletionCaller) {
        this.onPreCompletionCaller = onPreCompletionCaller;
    }

    public void setDontLog404(boolean dontLog404) {
        this.dontLog404 = dontLog404;
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelable) {
            for (Future request : this.pendingRequests) {
                CancellableRunnable runnable;
                if (!request.isCancelled()) {
                    request.cancel(mayInterruptIfRunning);
                }
                if ((runnable = this.runnables.get(request)) == null) continue;
                runnable.cancel();
            }
        }
        if (this.retryFuture != null && !this.retryFuture.isCancelled()) {
            this.retryFuture.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (this.retryCount <= MAX_RETRIES) {
            if (this.requestExecutor == null || this.requestExecutor.isShutdown() || this.completed.get()) {
                return null;
            }
            Future future = this.pendingRequests.poll(500L, TimeUnit.MILLISECONDS);
            if (future == null) continue;
            while (!future.isDone() && !future.isCancelled()) {
                try {
                    future.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {}
            }
        }
        return null;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    private RemoteRequest generateRemoteRequest() {
        RemoteRequest request;
        this.requestHttpResponse = null;
        this.requestResult = null;
        this.requestThrowable = null;
        switch (this.requestType) {
            case REMOTE_MULTIPART_REQUEST: {
                request = new RemoteMultipartRequest(this.clientFactory, this.method, this.url, this.syncGateway, this.cancelable, this.body, this.attachments, this.db, this.requestHeaders, this.onCompletionInner);
                break;
            }
            case REMOTE_MULTIPART_DOWNLOADER_REQUEST: {
                request = new RemoteMultipartDownloaderRequest(this.clientFactory, this.method, this.url, this.cancelable, this.body, this.db, this.requestHeaders, this.onCompletionInner);
                break;
            }
            default: {
                request = new RemoteRequest(this.clientFactory, this.method, this.url, this.cancelable, this.body, this.requestHeaders, this.onCompletionInner);
            }
        }
        request.setDontLog404(this.dontLog404);
        if (this.authenticator != null) {
            request.setAuthenticator(this.authenticator);
        }
        if (this.onPreCompletionCaller != null) {
            request.setOnPreCompletion(this.onPreCompletionCaller);
        }
        return request;
    }

    private void removeFromQueue() {
        if (this.queue != null) {
            this.queue.remove(this);
            this.setQueue(null);
        }
    }

    private boolean isTransientError(Response response, Throwable e) {
        Log.d(TAG, "%s: isTransientError, httpResponse: %s e: %s", this, response, e);
        if (response != null) {
            Log.d(TAG, "%s: isTransientError, status code: %d", this, response.code());
            if (Utils.isTransientError(response)) {
                Log.d(TAG, "%s: isTransientError, detect a transient error", this);
                return true;
            }
        }
        if ((response == null || response.code() < 400) && e instanceof IOException) {
            Log.d(TAG, "%s: isTransientError, detect an IOException which is a transient error", this);
            return true;
        }
        Log.d(TAG, "%s: isTransientError, return false", this);
        return false;
    }

    public static enum RemoteRequestType {
        REMOTE_REQUEST,
        REMOTE_MULTIPART_REQUEST,
        REMOTE_MULTIPART_DOWNLOADER_REQUEST;

    }
}

