/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;

public class RemoteRequestResponseException
extends IOException {
    public static int BAD_URL = -1000;
    public static int USER_DENIED_AUTH = -1012;
    private final int code;
    private Map userInfo;

    public RemoteRequestResponseException(int code, String s) {
        super(s);
        this.code = code;
        this.userInfo = null;
    }

    public RemoteRequestResponseException(int code, String s, Map userInfo) {
        this(code, s);
        this.userInfo = userInfo;
    }

    public int getCode() {
        return this.code;
    }

    public Map getUserInfo() {
        return this.userInfo;
    }

    @Override
    public String toString() {
        String strUserInfo;
        String className = this.getClass().getName();
        String message = this.getLocalizedMessage();
        String string = strUserInfo = this.userInfo != null ? this.userInfo.toString() : null;
        if (message != null && strUserInfo != null) {
            return String.format(Locale.ENGLISH, "%s: {code=%d, userInfo=%s, message=%s}", className, this.code, strUserInfo, message);
        }
        if (message != null && strUserInfo == null) {
            return String.format(Locale.ENGLISH, "%s: {code=%d, message=%s}", className, this.code, message);
        }
        if (message == null && strUserInfo != null) {
            return String.format(Locale.ENGLISH, "%s: {code=%d, userInfo=%s}", className, this.code, strUserInfo);
        }
        return String.format(Locale.ENGLISH, "%s: {code=%d}", className, this.code);
    }
}

