/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.ChangeTrackerBackoff;
import com.couchbase.lite.replicator.ChangeTrackerClient;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.RequestUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

@InterfaceAudience.Private
public class ChangeTracker
implements Runnable {
    private static final int TIMEOUT_FOR_PAUSE = 5000;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private URL databaseURL;
    private Object lastSequenceID;
    private boolean continuous = false;
    private Throwable error;
    private ChangeTrackerClient client;
    protected Map<String, Object> requestHeaders;
    private Authenticator authenticator;
    private boolean usePOST;
    private boolean activeOnly = false;
    private ChangeTrackerMode mode;
    private String filterName;
    private Map<String, Object> filterParams;
    private int limit;
    private int heartBeatSeconds;
    private List<String> docIDs;
    private boolean paused = false;
    private final Object pausedObj = new Object();
    private boolean includeConflicts;
    private Thread thread;
    private boolean running = false;
    private Request request;
    private Call call;
    private InputStream inputStream = null;
    protected ChangeTrackerBackoff backoff;
    private long startTime = 0L;
    private String str = null;
    private boolean caughtUp = false;

    public ChangeTracker(URL databaseURL, ChangeTrackerMode mode, boolean includeConflicts, Object lastSequenceID, ChangeTrackerClient client) {
        this.databaseURL = databaseURL;
        this.mode = mode;
        this.includeConflicts = includeConflicts;
        this.lastSequenceID = lastSequenceID;
        this.client = client;
        this.limit = 0;
        this.requestHeaders = new HashMap<String, Object>();
        this.heartBeatSeconds = Replication.DEFAULT_HEARTBEAT;
        this.usePOST = true;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.filterParams = filterParams;
    }

    public void setClient(ChangeTrackerClient client) {
        this.client = client;
    }

    public boolean isActiveOnly() {
        return this.activeOnly;
    }

    public void setActiveOnly(boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public String getFeed() {
        switch (this.mode) {
            case OneShot: {
                return "normal";
            }
            case LongPoll: {
                return "longpoll";
            }
            case Continuous: {
                return "continuous";
            }
        }
        return "normal";
    }

    public long getHeartbeatMilliseconds() {
        return this.heartBeatSeconds * 1000;
    }

    String getChangesFeedPath() {
        Object seq;
        StringBuilder sb = new StringBuilder(String.format(Locale.ENGLISH, "_changes?feed=%s&heartbeat=%d", this.getFeed(), this.getHeartbeatMilliseconds()));
        if (this.includeConflicts) {
            sb.append("&style=all_docs");
        }
        if ((seq = this.lastSequenceID) != null) {
            if (seq instanceof List || seq instanceof Map) {
                try {
                    seq = Manager.getObjectMapper().writeValueAsString(seq);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            sb.append("&since=");
            sb.append(URLEncoder.encode(seq.toString()));
        }
        if (this.activeOnly && !this.caughtUp) {
            sb.append("&active_only=true");
        }
        if (this.limit > 0) {
            sb.append("&limit=");
            sb.append(this.limit);
        }
        if (this.docIDs != null && this.docIDs.size() > 0) {
            this.filterName = "_doc_ids";
            this.filterParams = new HashMap<String, Object>();
            this.filterParams.put("doc_ids", this.docIDs);
        }
        if (this.filterName != null) {
            sb.append("&filter=");
            sb.append(URLEncoder.encode(this.filterName));
            if (!this.usePOST && this.filterParams != null) {
                for (String key : this.filterParams.keySet()) {
                    Object value = this.filterParams.get(key);
                    if (!(value instanceof String)) {
                        try {
                            value = Manager.getObjectMapper().writeValueAsString(value);
                        }
                        catch (JsonProcessingException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    sb.append("&");
                    sb.append(URLEncoder.encode(key));
                    sb.append("=");
                    sb.append(URLEncoder.encode(value.toString()));
                }
            }
        }
        return sb.toString();
    }

    public URL getChangesFeedURL() {
        String dbURLString = this.databaseURL.toExternalForm();
        if (!dbURLString.endsWith("/")) {
            dbURLString = dbURLString + "/";
        }
        dbURLString = dbURLString + this.getChangesFeedPath();
        URL result = null;
        try {
            result = new URL(dbURLString);
        }
        catch (MalformedURLException e) {
            Log.e("ChangeTracker", this + ": Changes feed ULR is malformed", e);
        }
        return result;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void run() {
        Log.d("ChangeTracker", "Thread id => " + Thread.currentThread().getId());
        try {
            this.runLoop();
        }
        finally {
            this.stopped();
        }
    }

    private boolean isResponseFailed(Response resp) {
        if (resp.code() < 300) {
            return false;
        }
        if (!Utils.isPermanentError(resp) && (this.mode == ChangeTrackerMode.LongPoll || Utils.isTransientError(resp))) {
            return false;
        }
        Log.w("ChangeTracker", "%s: Change tracker got error %d", this, resp.code());
        this.error = new RemoteRequestResponseException(resp.code(), resp.message());
        return true;
    }

    private boolean retryIfFailedPost(Response response) {
        if (!this.usePOST) {
            return false;
        }
        if (response.code() != 405 && !this.isCloudantAuthError(response)) {
            return false;
        }
        this.usePOST = false;
        return true;
    }

    private boolean isCloudantAuthError(Response response) {
        String server = response.header("Server");
        if (server == null || server.indexOf("CouchDB/") == -1) {
            return false;
        }
        return response.code() == 403;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runLoop() {
        this.paused = false;
        if (this.client == null) {
            Log.w("ChangeTracker", "%s: ChangeTracker run() loop aborting because client == null", this);
            return;
        }
        if (this.mode == ChangeTrackerMode.Continuous) {
            throw new RuntimeException("ChangeTracker does not correctly support continuous mode");
        }
        OkHttpClient httpClient = this.client.getOkHttpClient();
        this.backoff = new ChangeTrackerBackoff();
        while (this.running) {
            this.startTime = System.currentTimeMillis();
            Request.Builder builder = new Request.Builder();
            URL url = this.getChangesFeedURL();
            builder.url(url);
            if (this.usePOST) {
                builder.header("Content-Type", "application/json").addHeader("User-Agent", Manager.getUserAgent()).addHeader("Accept-Encoding", "gzip").post(RequestBody.create((MediaType)JSON, (String)this.changesFeedPOSTBody()));
            }
            this.addRequestHeaders(builder);
            builder = RequestUtils.preemptivelySetAuthCredentials(builder, url, this.authenticator);
            this.request = builder.build();
            try {
                String maskedRemoteWithoutCredentials = this.getChangesFeedURL().toString();
                maskedRemoteWithoutCredentials = maskedRemoteWithoutCredentials.replaceAll("://.*:.*@", "://---:---@");
                Log.v("ChangeTracker", "%s: Making request to %s [%s]", this, this.usePOST ? "POST" : "GET", maskedRemoteWithoutCredentials);
                this.call = httpClient.newCall(this.request);
                Response response = this.call.execute();
                try {
                    if (this.isResponseFailed(response)) {
                        RequestUtils.closeResponseBody(response);
                        if (!this.retryIfFailedPost(response)) break;
                        this.error = null;
                        continue;
                    }
                    ResponseBody responseBody = response.body();
                    Log.v("ChangeTracker", "%s: got response. status: %s mode: %s", new Object[]{this, response.message(), this.mode});
                    if (responseBody == null) continue;
                    try {
                        JsonToken token;
                        Log.v("ChangeTracker", "%s: /entity.getContent().  mode: %s", new Object[]{this, this.mode});
                        this.inputStream = responseBody.byteStream();
                        if (Utils.isGzip(response)) {
                            this.inputStream = new GZIPInputStream(this.inputStream);
                        }
                        if (this.mode == ChangeTrackerMode.LongPoll) {
                            boolean responseOK = false;
                            if (responseBody.contentLength() != 0L && response.code() < 300) {
                                try {
                                    Log.v("ChangeTracker", "%s: readValue", this);
                                    Map fullBody = (Map)Manager.getObjectMapper().readValue(this.inputStream, Map.class);
                                    Log.v("ChangeTracker", "%s: /readValue.  fullBody: %s", this, fullBody);
                                    responseOK = this.receivedPollResponse(fullBody);
                                }
                                catch (JsonParseException jpe) {
                                    Log.w("ChangeTracker", "%s: json parsing error; %s", this, jpe.toString());
                                }
                                catch (JsonMappingException jme) {
                                    Log.w("ChangeTracker", "%s: json mapping error; %s", this, jme.toString());
                                }
                            }
                            Log.v("ChangeTracker", "%s: responseOK: %s", this, responseOK);
                            if (responseOK) {
                                if (!this.caughtUp) {
                                    this.caughtUp = true;
                                    this.client.changeTrackerCaughtUp();
                                }
                                Log.v("ChangeTracker", "%s: Starting new longpoll", this);
                                this.backoff.resetBackoff();
                                continue;
                            }
                            long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
                            Log.w("ChangeTracker", "%s: Longpoll connection closed (by proxy?) after %d sec", this, elapsed);
                            if (elapsed >= 30L) {
                                this.heartBeatSeconds = Math.min(this.heartBeatSeconds, (int)((double)elapsed * 0.75));
                                Log.v("ChangeTracker", "%s: Starting new longpoll", this);
                                this.backoff.resetBackoff();
                                continue;
                            }
                            Log.d("ChangeTracker", "%s: Change tracker calling stop (LongPoll)", this);
                            this.client.changeTrackerFinished(this);
                            break;
                        }
                        Log.v("ChangeTracker", "%s: readValue (oneshot)", this);
                        JsonFactory factory = new JsonFactory();
                        JsonParser jp = factory.createParser(this.inputStream);
                        while ((token = jp.nextToken()) != JsonToken.START_ARRAY && token != null) {
                        }
                        while (jp.nextToken() == JsonToken.START_OBJECT) {
                            Map change = (Map)Manager.getObjectMapper().readValue(jp, Map.class);
                            if (!this.receivedChange(change)) {
                                Log.w("ChangeTracker", "Received unparseable change line from server: %s", change);
                            }
                            if (this.running) continue;
                            break;
                        }
                        if (jp != null) {
                            jp.close();
                        }
                        Log.v("ChangeTracker", "%s: /readValue (oneshot)", this);
                        this.client.changeTrackerCaughtUp();
                        if (!this.isContinuous()) {
                            Log.d("ChangeTracker", "%s: Change tracker calling stop (OneShot)", this);
                            this.client.changeTrackerFinished(this);
                            break;
                        }
                        this.mode = ChangeTrackerMode.LongPoll;
                        this.backoff.resetBackoff();
                    }
                    finally {
                        try {
                            if (this.inputStream == null) continue;
                            this.inputStream.close();
                            this.inputStream = null;
                        }
                        catch (IOException jme) {}
                    }
                }
                finally {
                    RequestUtils.closeResponseBody(response);
                }
            }
            catch (Exception e) {
                if (this.running || !(e instanceof IOException)) {
                    Log.w("ChangeTracker", this + ": Exception in change tracker", e);
                    this.error = e;
                }
                this.backoff.sleepAppropriateAmountOfTime();
            }
        }
        Log.v("ChangeTracker", "%s: Change tracker run loop exiting", this);
    }

    public boolean receivedChange(Map<String, Object> change) {
        this.waitIfPaused();
        if (this.running) {
            Object seq = change.get("seq");
            if (seq == null) {
                return false;
            }
            if (this.client != null) {
                Log.d("ChangeTracker", "%s: changeTrackerReceivedChange: %s", this, change);
                this.client.changeTrackerReceivedChange(change);
                Log.d("ChangeTracker", "%s: /changeTrackerReceivedChange: %s", this, change);
            }
            this.lastSequenceID = seq;
        }
        return true;
    }

    public boolean receivedPollResponse(Map<String, Object> response) {
        List changes = (List)response.get("results");
        if (changes == null) {
            return false;
        }
        for (Map change : changes) {
            if (!this.receivedChange(change)) {
                return false;
            }
            if (this.running) continue;
            break;
        }
        return true;
    }

    public void setUpstreamError(String message) {
        Log.w("ChangeTracker", "Server error: %s", message);
        this.error = new Throwable(message);
    }

    public boolean start() {
        Log.d("ChangeTracker", "%s: Changed tracker asked to start", this);
        this.running = true;
        this.error = null;
        String maskedRemoteWithoutCredentials = this.databaseURL.toExternalForm();
        maskedRemoteWithoutCredentials = maskedRemoteWithoutCredentials.replaceAll("://.*:.*@", "://---:---@");
        this.thread = new Thread((Runnable)this, "ChangeTracker-" + maskedRemoteWithoutCredentials);
        this.thread.start();
        return true;
    }

    public void stop() {
        Log.d("ChangeTracker", "%s: Changed tracker asked to stop", this);
        this.running = false;
        this.setPaused(false);
        if (this.call != null) {
            Log.d("ChangeTracker", "%s: Changed tracker aborting request: %s", this, this.request);
            this.call.cancel();
        }
        try {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            Log.d("ChangeTracker", "%s: Exception interrupting thread: %s", this);
        }
    }

    private void stopped() {
        Log.d("ChangeTracker", "%s: Change tracker in stopped()", this);
        this.running = false;
        if (this.client != null) {
            Log.d("ChangeTracker", "%s: Change tracker calling changeTrackerStopped, client: %s", this, this.client);
            this.client.changeTrackerStopped(this);
        } else {
            Log.d("ChangeTracker", "%s: Change tracker not calling changeTrackerStopped, client == null", this);
        }
        this.client = null;
    }

    public void setRequestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    private void addRequestHeaders(Request.Builder builder) {
        if (this.requestHeaders != null) {
            for (String requestHeaderKey : this.requestHeaders.keySet()) {
                builder.addHeader(requestHeaderKey, this.requestHeaders.get(requestHeaderKey).toString());
            }
        }
    }

    public Throwable getLastError() {
        Log.d("ChangeTracker", "%s: getLastError() %s", this, this.error);
        return this.error;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setDocIDs(List<String> docIDs) {
        this.docIDs = docIDs;
    }

    public String changesFeedPOSTBody() {
        Map<String, Object> postBodyMap = this.changesFeedPOSTBodyMap();
        try {
            return Manager.getObjectMapper().writeValueAsString(postBodyMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setUsePOST(boolean usePOST) {
        this.usePOST = usePOST;
    }

    public Map<String, Object> changesFeedPOSTBodyMap() {
        Object since = this.lastSequenceID;
        if (this.lastSequenceID != null && this.lastSequenceID instanceof String) {
            try {
                Long value = Long.valueOf((String)this.lastSequenceID);
                if (value >= 0L) {
                    since = value;
                }
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        if (this.docIDs != null && this.docIDs.size() > 0) {
            this.filterName = "_doc_ids";
            this.filterParams = new HashMap<String, Object>();
            this.filterParams.put("doc_ids", this.docIDs);
        }
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("feed", this.getFeed());
        post.put("heartbeat", this.getHeartbeatMilliseconds());
        if (this.includeConflicts) {
            post.put("style", "all_docs");
        }
        if (this.activeOnly && !this.caughtUp) {
            post.put("active_only", true);
        }
        if (since != null) {
            post.put("since", since);
        }
        if (this.filterName != null) {
            post.put("filter", this.filterName);
        }
        if (this.limit > 0) {
            post.put("limit", this.limit);
        }
        if (this.filterName != null && this.filterParams != null) {
            for (String key : this.filterParams.keySet()) {
                Object value = this.filterParams.get(key);
                if (value == null) continue;
                post.put(key, value);
            }
        }
        return post;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        Log.v("CBLite", "setPaused: " + paused);
        Object object = this.pausedObj;
        synchronized (object) {
            if (this.paused != paused) {
                this.paused = paused;
                this.pausedObj.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitIfPaused() {
        Object object = this.pausedObj;
        synchronized (object) {
            while (this.paused && this.running) {
                Log.v("CBLite", "Waiting: " + this.paused);
                try {
                    this.pausedObj.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        if (this.str == null) {
            String remoteURL = this.databaseURL.toExternalForm().replaceAll("://.*:.*@", "://---:---@");
            this.str = String.format(Locale.ENGLISH, "ChangeTracker{%s, %s, @%s}", new Object[]{remoteURL, this.mode, Integer.toHexString(this.hashCode())});
        }
        return this.str;
    }

    public static enum ChangeTrackerMode {
        OneShot,
        LongPoll,
        Continuous;

    }
}

