/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.sqlite;

import com.couchbase.lite.internal.database.cursor.Cursor;
import com.couchbase.lite.internal.database.log.DLog;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnection;
import com.couchbase.lite.internal.database.sqlite.SQLiteQuery;

public class SQLiteQueryCursor
implements Cursor {
    private static final String TAG = "SQLiteQueryCursor";
    private final SQLiteQuery mQuery;
    private SQLiteConnection.PreparedStatement mPreparedStatement;
    private boolean isAfterLast = false;
    private final String[] mColumns;

    private static native boolean nativeMoveToNext(long var0);

    private static native boolean nativeIsAfterLast(long var0);

    private static native String nativeGetString(long var0, int var2);

    private static native int nativeGetInt(long var0, int var2);

    private static native long nativeGetLong(long var0, int var2);

    private static native double nativeGetDouble(long var0, int var2);

    private static native byte[] nativeGetBlob(long var0, int var2);

    private static native boolean nativeIsNull(long var0, int var2);

    public SQLiteQueryCursor(SQLiteQuery query) {
        this.mQuery = query;
        this.mColumns = query != null ? query.getColumnNames() : new String[0];
    }

    @Override
    public boolean moveToNext() {
        if (this.mPreparedStatement == null) {
            this.mPreparedStatement = this.mQuery.beginQuery();
        }
        if (this.mPreparedStatement == null) {
            return false;
        }
        boolean didMove = SQLiteQueryCursor.nativeMoveToNext(this.mPreparedStatement.mStatementPtr);
        this.isAfterLast = !didMove;
        return didMove;
    }

    @Override
    public boolean isAfterLast() {
        return this.isAfterLast;
    }

    private String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            DLog.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    @Override
    public String getString(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeGetString(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public int getShort(int columnIndex) {
        return (short)this.getLong(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeGetInt(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeGetLong(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) {
        return (float)this.getDouble(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeGetDouble(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public byte[] getBlob(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeGetBlob(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        if (this.mPreparedStatement == null) {
            throw new IllegalStateException("No prepared statement.");
        }
        return SQLiteQueryCursor.nativeIsNull(this.mPreparedStatement.mStatementPtr, columnIndex);
    }

    @Override
    public void close() {
        if (this.mPreparedStatement == null) {
            return;
        }
        this.mQuery.endQuery(this.mPreparedStatement);
    }
}

