/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.sqlite;

import com.couchbase.lite.internal.database.CancellationSignal;
import com.couchbase.lite.internal.database.ContentValues;
import com.couchbase.lite.internal.database.DatabaseErrorHandler;
import com.couchbase.lite.internal.database.DatabasePlatformSupport;
import com.couchbase.lite.internal.database.SQLException;
import com.couchbase.lite.internal.database.cursor.Cursor;
import com.couchbase.lite.internal.database.log.DLog;
import com.couchbase.lite.internal.database.sqlite.SQLiteClosable;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnectionListener;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnectionPool;
import com.couchbase.lite.internal.database.sqlite.SQLiteCursorDriver;
import com.couchbase.lite.internal.database.sqlite.SQLiteDatabaseConfiguration;
import com.couchbase.lite.internal.database.sqlite.SQLiteDebug;
import com.couchbase.lite.internal.database.sqlite.SQLiteDirectCursorDriver;
import com.couchbase.lite.internal.database.sqlite.SQLiteQuery;
import com.couchbase.lite.internal.database.sqlite.SQLiteQueryBuilder;
import com.couchbase.lite.internal.database.sqlite.SQLiteSession;
import com.couchbase.lite.internal.database.sqlite.SQLiteStatement;
import com.couchbase.lite.internal.database.sqlite.SQLiteTransactionListener;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteDatabaseCorruptException;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteException;
import com.couchbase.lite.internal.database.util.DatabaseUtils;
import com.couchbase.lite.internal.database.util.Pair;
import com.couchbase.lite.internal.database.util.Printer;
import com.couchbase.lite.internal.database.util.TextUtils;
import com.couchbase.lite.storage.SQLiteNativeLibrary;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;

public final class SQLiteDatabase
extends SQLiteClosable {
    private static final String TAG = "SQLiteDatabase";
    private static WeakHashMap<SQLiteDatabase, Object> sActiveDatabases = new WeakHashMap();
    private final ThreadLocal<SQLiteSession> mThreadSession = new ThreadLocal<SQLiteSession>(){

        @Override
        protected SQLiteSession initialValue() {
            return SQLiteDatabase.this.createSession();
        }
    };
    private final CursorFactory mCursorFactory;
    private final DatabaseErrorHandler mErrorHandler;
    private final SQLiteConnectionListener mConnectionListener;
    private final Object mLock = new Object();
    private final SQLiteDatabaseConfiguration mConfigurationLocked;
    private SQLiteConnectionPool mConnectionPoolLocked;
    private boolean mHasAttachedDbsLocked;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READ_MASK = 1;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    public static final int MAX_SQL_CACHE_SIZE = 100;
    private static DatabasePlatformSupport platformSupport;

    private static native boolean nativeSupportEncryption();

    private SQLiteDatabase(String path, int openFlags, int walConnectionPoolSize, CursorFactory cursorFactory, DatabaseErrorHandler errorHandler, SQLiteConnectionListener connectionListener) {
        this.mCursorFactory = cursorFactory;
        this.mErrorHandler = errorHandler;
        this.mConfigurationLocked = new SQLiteDatabaseConfiguration(path, openFlags, walConnectionPoolSize);
        this.mConnectionListener = connectionListener;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean finalized) {
        SQLiteConnectionPool pool;
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            pool = this.mConnectionPoolLocked;
            this.mConnectionPoolLocked = null;
        }
        if (!finalized) {
            weakHashMap = sActiveDatabases;
            synchronized (weakHashMap) {
                sActiveDatabases.remove(this);
            }
            if (pool != null) {
                pool.close();
            }
        }
    }

    @Deprecated
    public void setLockingEnabled(boolean lockingEnabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLabel() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.label;
        }
    }

    void onCorruption() {
        if (this.mErrorHandler != null) {
            this.mErrorHandler.onCorruption(this);
        }
    }

    SQLiteSession getThreadSession() {
        return this.mThreadSession.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLiteSession createSession() {
        SQLiteConnectionPool pool;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            pool = this.mConnectionPoolLocked;
        }
        return new SQLiteSession(pool);
    }

    int getThreadDefaultConnectionFlags(boolean readOnly) {
        int flags;
        int n = flags = readOnly ? 1 : 2;
        if (SQLiteDatabase.isMainThread()) {
            flags |= 4;
        }
        return flags;
    }

    private static boolean isMainThread() {
        if (platformSupport != null) {
            return platformSupport.isMainThread();
        }
        return false;
    }

    public static boolean isSupportEncryption() {
        return SQLiteDatabase.nativeSupportEncryption();
    }

    public void beginTransaction() {
        this.beginTransaction(null, true);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransaction(null, false);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, true);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, false);
    }

    private void beginTransaction(SQLiteTransactionListener transactionListener, boolean exclusive) {
        this.acquireReference();
        try {
            this.getThreadSession().beginTransaction(exclusive ? 2 : 1, transactionListener, this.getThreadDefaultConnectionFlags(false), null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void endTransaction() {
        this.acquireReference();
        try {
            this.getThreadSession().endTransaction(null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void setTransactionSuccessful() {
        this.acquireReference();
        try {
            this.getThreadSession().setTransactionSuccessful();
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean inTransaction() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasTransaction();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean isDbLockedByCurrentThread() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasConnection();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isDbLockedByOtherThreads() {
        return false;
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean yieldIfContendedHelper(boolean throwIfUnsafe, long sleepAfterYieldDelay) {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().yieldTransaction(sleepAfterYieldDelay, throwIfUnsafe, null);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, factory, flags, null);
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, flags, 0, errorHandler, null);
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags, int walConnectionPoolSize, DatabaseErrorHandler errorHandler, SQLiteConnectionListener connectionListener) {
        SQLiteDatabase db = new SQLiteDatabase(path, flags, walConnectionPoolSize, factory, errorHandler, connectionListener);
        db.open();
        return db;
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, errorHandler);
    }

    public static void setDatabasePlatformSupport(DatabasePlatformSupport supporter) {
        platformSupport = supporter;
    }

    public static boolean deleteDatabase(File file) {
        String prefix;
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean deleted = false;
        deleted |= file.delete();
        deleted |= new File(file.getPath() + "-journal").delete();
        deleted |= new File(file.getPath() + "-shm").delete();
        deleted |= new File(file.getPath() + "-wal").delete();
        File dir = file.getParentFile();
        if (dir != null && (files = dir.listFiles(new FileFilter(prefix = file.getName() + "-mj"){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().startsWith(this.val$prefix);
            }
        })) != null) {
            for (File masterJournal : files) {
                deleted |= masterJournal.delete();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenReadWrite() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (!this.isReadOnlyLocked()) {
                return;
            }
            int oldOpenFlags = this.mConfigurationLocked.openFlags;
            this.mConfigurationLocked.openFlags = this.mConfigurationLocked.openFlags & 0xFFFFFFFE | 0;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldOpenFlags;
                throw ex;
            }
        }
    }

    private void open() {
        try {
            this.openInner();
        }
        catch (SQLiteException ex) {
            if (ex instanceof SQLiteDatabaseCorruptException) {
                try {
                    this.onCorruption();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DLog.e(TAG, "Failed to open database '" + this.getLabel() + "'.", ex);
            this.close();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openInner() {
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            assert (this.mConnectionPoolLocked == null);
            this.mConnectionPoolLocked = SQLiteConnectionPool.open(this.mConfigurationLocked, this.mConnectionListener);
        }
        weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(this, null);
        }
    }

    public static SQLiteDatabase create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 0x10000000);
    }

    public int getVersion() {
        return Long.valueOf(DatabaseUtils.longForQuery(this, "PRAGMA user_version;", null)).intValue();
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    public long getMaximumSize() {
        long pageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count;", null);
        return pageCount * this.getPageSize();
    }

    public long setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count = " + numPages, null);
        return newPageCount * pageSize;
    }

    public long getPageSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA page_size;", null);
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    @Deprecated
    public void markTableSyncable(String table, String deletedTable) {
    }

    @Deprecated
    public void markTableSyncable(String table, String foreignKey, String updateTable) {
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.acquireReference();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql, null);
            return sQLiteStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(cursorFactory, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
            Cursor cursor = this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table), cancellationSignal);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, null);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs, CancellationSignal cancellationSignal) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, cancellationSignal);
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, editTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable, cancellationSignal);
            Cursor cursor = driver.query(cursorFactory != null ? cursorFactory : this.mCursorFactory, selectionArgs);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            DLog.e(TAG, "Error inserting " + values, e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            DLog.e(TAG, "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        this.acquireReference();
        try {
            long l;
            int size;
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(" INTO ");
            sql.append(table);
            sql.append('(');
            Object[] bindArgs = null;
            int n = size = initialValues != null && initialValues.size() > 0 ? initialValues.size() : 0;
            if (size > 0) {
                bindArgs = new Object[size];
                int i = 0;
                for (String colName : initialValues.keySet()) {
                    sql.append(i > 0 ? "," : "");
                    sql.append(colName);
                    bindArgs[i++] = initialValues.get(colName);
                }
                sql.append(')');
                sql.append(" VALUES (");
                for (i = 0; i < size; ++i) {
                    sql.append(i > 0 ? ",?" : "?");
                }
            } else {
                sql.append(nullColumnHack + ") VALUES (NULL");
            }
            sql.append(')');
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                l = statement.executeInsert();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String table, String whereClause, String[] whereArgs) {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""), whereArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        this.acquireReference();
        try {
            int n;
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            Object[] bindArgs = new Object[bindArgsSize];
            int i = 0;
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i++] = values.get(colName);
                sql.append("=?");
            }
            if (whereArgs != null) {
                for (i = setValuesSize; i < bindArgsSize; ++i) {
                    bindArgs[i] = whereArgs[i - setValuesSize];
                }
            }
            if (!TextUtils.isEmpty(whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeSql(String sql, Object[] bindArgs) throws SQLException {
        this.acquireReference();
        try {
            int n;
            if (DatabaseUtils.getSqlStatementType(sql) == 3) {
                boolean disableWal = false;
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.mHasAttachedDbsLocked) {
                        this.mHasAttachedDbsLocked = true;
                        disableWal = true;
                    }
                }
                if (disableWal) {
                    this.disableWriteAheadLogging();
                }
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql, bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() {
        Object object = this.mLock;
        synchronized (object) {
            return this.isReadOnlyLocked();
        }
    }

    private boolean isReadOnlyLocked() {
        return (this.mConfigurationLocked.openFlags & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInMemoryDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.isInMemoryDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectionPoolLocked != null;
        }
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            Locale oldLocale = this.mConfigurationLocked.locale;
            this.mConfigurationLocked.locale = locale;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.locale = oldLocale;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 100 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 100");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int oldMaxSqlCacheSize = this.mConfigurationLocked.maxSqlCacheSize;
            this.mConfigurationLocked.maxSqlCacheSize = cacheSize;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.maxSqlCacheSize = oldMaxSqlCacheSize;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignKeyConstraintsEnabled(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.foreignKeyConstraintsEnabled == enable) {
                return;
            }
            this.mConfigurationLocked.foreignKeyConstraintsEnabled = enable;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.foreignKeyConstraintsEnabled = !enable;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((this.mConfigurationLocked.openFlags & 0x20000000) != 0) {
                return true;
            }
            if (this.isReadOnlyLocked()) {
                return false;
            }
            if (this.mConfigurationLocked.isInMemoryDb()) {
                DLog.i(TAG, "can't enable WAL for memory databases.");
                return false;
            }
            if (this.mHasAttachedDbsLocked) {
                DLog.d(TAG, "this database: " + this.mConfigurationLocked.label + " has attached databases. can't  enable WAL.");
                return false;
            }
            this.mConfigurationLocked.openFlags |= 0x20000000;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((this.mConfigurationLocked.openFlags & 0x20000000) == 0) {
                return;
            }
            this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags |= 0x20000000;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAheadLoggingEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            return (this.mConfigurationLocked.openFlags & 0x20000000) != 0;
        }
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.collectDbStats(dbStatsList);
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                this.mConnectionPoolLocked.collectDbStats(dbStatsList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        ArrayList<SQLiteDatabase> databases = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            databases.addAll(sActiveDatabases.keySet());
        }
        return databases;
    }

    static void dumpAll(Printer printer, boolean verbose) {
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.dump(printer, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Printer printer, boolean verbose) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                printer.println("");
                this.mConnectionPoolLocked.dump(printer, verbose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getAttachedDbs() {
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked == null) {
                return null;
            }
            if (!this.mHasAttachedDbsLocked) {
                attachedDbs.add(new Pair<String, String>("main", this.mConfigurationLocked.path));
                return attachedDbs;
            }
            this.acquireReference();
        }
        try {
            Cursor c = null;
            try {
                c = this.rawQuery("pragma database_list;", null);
                while (c.moveToNext()) {
                    attachedDbs.add(new Pair<String, String>(c.getString(1), c.getString(2)));
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            ArrayList<Pair<String, String>> arrayList = attachedDbs;
            return arrayList;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk() {
        this.acquireReference();
        try {
            List<Pair<String, String>> attachedDbs = null;
            try {
                attachedDbs = this.getAttachedDbs();
                if (attachedDbs == null) {
                    throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't " + "be retrieved. probably because the database is closed");
                }
            }
            catch (SQLiteException e) {
                attachedDbs = new ArrayList<Pair<String, String>>();
                attachedDbs.add(new Pair<String, String>("main", this.getPath()));
            }
            for (int i = 0; i < attachedDbs.size(); ++i) {
                Pair<String, String> p = attachedDbs.get(i);
                SQLiteClosable prog = null;
                try {
                    prog = this.compileStatement("PRAGMA " + (String)p.first + ".integrity_check(1);");
                    String rslt = ((SQLiteStatement)prog).simpleQueryForString();
                    if (rslt.equalsIgnoreCase("ok")) continue;
                    DLog.e(TAG, "PRAGMA integrity_check on " + (String)p.second + " returned: " + rslt);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (prog != null) {
                        prog.close();
                    }
                }
            }
        }
        finally {
            this.releaseReference();
        }
        return true;
    }

    public String toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    private void throwIfNotOpenLocked() {
        if (this.mConnectionPoolLocked == null) {
            throw new IllegalStateException("The database '" + this.mConfigurationLocked.label + "' is not open.");
        }
    }

    static {
        SQLiteNativeLibrary.load();
    }

    public static interface CustomFunction {
        public void callback(String[] var1);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }
}

