/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.sqlite;

import com.couchbase.lite.internal.database.CancellationSignal;
import com.couchbase.lite.internal.database.log.DLog;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnectionListener;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnectionPool;
import com.couchbase.lite.internal.database.sqlite.SQLiteDatabaseConfiguration;
import com.couchbase.lite.internal.database.sqlite.SQLiteDebug;
import com.couchbase.lite.internal.database.sqlite.SQLiteGlobal;
import com.couchbase.lite.internal.database.sqlite.SQLiteStatementInfo;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteBindOrColumnIndexOutOfRangeException;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteDatabaseLockedException;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteException;
import com.couchbase.lite.internal.database.util.DatabaseUtils;
import com.couchbase.lite.internal.database.util.Printer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public final class SQLiteConnection
implements CancellationSignal.OnCancelListener {
    private static final String TAG = "SQLiteConnection";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final SQLiteConnectionPool mPool;
    private final SQLiteDatabaseConfiguration mConfiguration;
    private final SQLiteConnectionListener mConnectionListener;
    private final int mConnectionId;
    private final boolean mIsPrimaryConnection;
    private final boolean mIsReadOnlyConnection;
    private PreparedStatement mPreparedStatementPool;
    private final OperationLog mRecentOperations = new OperationLog();
    private long mConnectionPtr;
    private boolean mOnlyAllowReadOnlyOperations;
    private int mCancellationSignalAttachCount;

    private static native long nativeOpen(String var0, int var1, String var2, boolean var3, boolean var4);

    private static native void nativeClose(long var0);

    private static native long nativePrepareStatement(long var0, String var2);

    private static native void nativeFinalizeStatement(long var0, long var2);

    private static native int nativeGetParameterCount(long var0, long var2);

    private static native boolean nativeIsReadOnly(long var0, long var2);

    private static native int nativeGetColumnCount(long var0, long var2);

    private static native String nativeGetColumnName(long var0, long var2, int var4);

    private static native void nativeBindNull(long var0, long var2, int var4);

    private static native void nativeBindLong(long var0, long var2, int var4, long var5);

    private static native void nativeBindDouble(long var0, long var2, int var4, double var5);

    private static native void nativeBindString(long var0, long var2, int var4, String var5);

    private static native void nativeBindBlob(long var0, long var2, int var4, byte[] var5);

    private static native void nativeResetStatementAndClearBindings(long var0, long var2);

    private static native void nativeExecute(long var0, long var2);

    private static native long nativeExecuteForLong(long var0, long var2);

    private static native String nativeExecuteForString(long var0, long var2);

    private static native int nativeExecuteForChangedRowCount(long var0, long var2);

    private static native long nativeExecuteForLastInsertedRowId(long var0, long var2);

    private static native int nativeGetDbLookaside(long var0);

    private static native void nativeCancel(long var0);

    private static native void nativeResetCancel(long var0, boolean var2);

    private SQLiteConnection(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, SQLiteConnectionListener connectionListener, int connectionId, boolean primaryConnection) {
        this.mPool = pool;
        this.mConfiguration = new SQLiteDatabaseConfiguration(configuration);
        this.mConnectionListener = connectionListener;
        this.mConnectionId = connectionId;
        this.mIsPrimaryConnection = primaryConnection;
        this.mIsReadOnlyConnection = (configuration.openFlags & 1) != 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPool != null && this.mConnectionPtr != 0L) {
                this.mPool.onConnectionLeaked();
            }
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    static SQLiteConnection open(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, SQLiteConnectionListener connectionListener, int connectionId, boolean primaryConnection) {
        SQLiteConnection connection = new SQLiteConnection(pool, configuration, connectionListener, connectionId, primaryConnection);
        try {
            connection.open();
            return connection;
        }
        catch (SQLiteException ex) {
            connection.dispose(false);
            throw ex;
        }
    }

    void close() {
        this.dispose(false);
    }

    private void open() {
        this.mConnectionPtr = SQLiteConnection.nativeOpen(this.mConfiguration.path, this.mConfiguration.openFlags, this.mConfiguration.label, false, false);
        if (this.mConnectionListener != null) {
            this.mConnectionListener.onOpen(this);
        }
        this.setForeignKeyModeFromConfiguration();
        this.setWalModeFromConfiguration();
        this.setJournalSizeLimit();
        this.setAutoCheckpointInterval();
    }

    private void dispose(boolean finalized) {
        if (this.mConnectionPtr != 0L) {
            int cookie = this.mRecentOperations.beginOperation("close", null, null);
            try {
                SQLiteConnection.nativeClose(this.mConnectionPtr);
                this.mConnectionPtr = 0L;
                if (this.mConnectionListener != null) {
                    this.mConnectionListener.onClose(this);
                }
            }
            finally {
                this.mRecentOperations.endOperation(cookie);
            }
        }
    }

    private void setPageSize() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getDefaultPageSize();
            long value = this.executeForLong("PRAGMA page_size", null, null);
            if (value != newValue) {
                this.execute("PRAGMA page_size=" + newValue, null, null);
            }
        }
    }

    private void setAutoCheckpointInterval() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getWALAutoCheckpoint();
            long value = this.executeForLong("PRAGMA wal_autocheckpoint", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA wal_autocheckpoint=" + newValue, null, null);
            }
        }
    }

    private void setJournalSizeLimit() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getJournalSizeLimit();
            long value = this.executeForLong("PRAGMA journal_size_limit", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA journal_size_limit=" + newValue, null, null);
            }
        }
    }

    private void setForeignKeyModeFromConfiguration() {
        if (!this.mIsReadOnlyConnection) {
            long newValue = this.mConfiguration.foreignKeyConstraintsEnabled ? 1L : 0L;
            long value = this.executeForLong("PRAGMA foreign_keys", null, null);
            if (value != newValue) {
                this.execute("PRAGMA foreign_keys=" + newValue, null, null);
            }
        }
    }

    private void setWalModeFromConfiguration() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            if ((this.mConfiguration.openFlags & 0x20000000) != 0) {
                this.setJournalMode("WAL");
                this.setSyncMode(SQLiteGlobal.getWALSyncMode());
            } else {
                this.setJournalMode(SQLiteGlobal.getDefaultJournalMode());
                this.setSyncMode(SQLiteGlobal.getDefaultSyncMode());
            }
        }
    }

    private void setSyncMode(String newValue) {
        String value = this.executeForString("PRAGMA synchronous", null, null);
        if (!SQLiteConnection.canonicalizeSyncMode(value).equalsIgnoreCase(SQLiteConnection.canonicalizeSyncMode(newValue))) {
            this.execute("PRAGMA synchronous=" + newValue, null, null);
        }
    }

    private static String canonicalizeSyncMode(String value) {
        if (value.equals("0")) {
            return "OFF";
        }
        if (value.equals("1")) {
            return "NORMAL";
        }
        if (value.equals("2")) {
            return "FULL";
        }
        return value;
    }

    private void setJournalMode(String newValue) {
        String value = this.executeForString("PRAGMA journal_mode", null, null);
        if (!value.equalsIgnoreCase(newValue)) {
            try {
                String result = this.executeForString("PRAGMA journal_mode=" + newValue, null, null);
                if (result.equalsIgnoreCase(newValue)) {
                    return;
                }
            }
            catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                // empty catch block
            }
            DLog.w(TAG, "Could not change the database journal mode of '" + this.mConfiguration.label + "' from '" + value + "' to '" + newValue + "' because the database is locked.  This usually means that " + "there are other open connections to the database which prevents " + "the database from enabling or disabling write-ahead logging mode.  " + "Proceeding without changing the journal mode.");
        }
    }

    void reconfigure(SQLiteDatabaseConfiguration configuration) {
        this.mOnlyAllowReadOnlyOperations = false;
        boolean foreignKeyModeChanged = configuration.foreignKeyConstraintsEnabled != this.mConfiguration.foreignKeyConstraintsEnabled;
        boolean walModeChanged = ((configuration.openFlags ^ this.mConfiguration.openFlags) & 0x20000000) != 0;
        this.mConfiguration.updateParametersFrom(configuration);
        if (foreignKeyModeChanged) {
            this.setForeignKeyModeFromConfiguration();
        }
        if (walModeChanged) {
            this.setWalModeFromConfiguration();
        }
    }

    void setOnlyAllowReadOnlyOperations(boolean readOnly) {
        this.mOnlyAllowReadOnlyOperations = readOnly;
    }

    public int getConnectionId() {
        return this.mConnectionId;
    }

    public boolean isPrimaryConnection() {
        return this.mIsPrimaryConnection;
    }

    public long getConnectionHandle() {
        return this.mConnectionPtr;
    }

    public Locale getLocale() {
        return this.mConfiguration.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String sql, SQLiteStatementInfo outStatementInfo) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("prepare", sql, null);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                if (outStatementInfo != null) {
                    outStatementInfo.numParameters = statement.mNumParameters;
                    outStatementInfo.readOnly = statement.mReadOnly;
                    int columnCount = SQLiteConnection.nativeGetColumnCount(this.mConnectionPtr, statement.mStatementPtr);
                    if (columnCount == 0) {
                        outStatementInfo.columnNames = EMPTY_STRING_ARRAY;
                    } else {
                        outStatementInfo.columnNames = new String[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            outStatementInfo.columnNames[i] = SQLiteConnection.nativeGetColumnName(this.mConnectionPtr, statement.mStatementPtr, i);
                        }
                    }
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("execute", sql, bindArgs);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                this.throwIfStatementForbidden(statement);
                this.bindArguments(statement, bindArgs);
                this.applyBlockGuardPolicy(statement);
                this.attachCancellationSignal(cancellationSignal);
                try {
                    SQLiteConnection.nativeExecute(this.mConnectionPtr, statement.mStatementPtr);
                }
                finally {
                    this.detachCancellationSignal(cancellationSignal);
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * Exception decompiling
     */
    public long executeForLong(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String executeForString(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int executeForChangedRowCount(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long executeForLastInsertedRowId(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PreparedStatement executePrepareStatementNoRelease(String sql, Object[] bindArgs) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("executePrepareStatement", sql, bindArgs);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            this.throwIfStatementForbidden(statement);
            this.bindArguments(statement, bindArgs);
            this.applyBlockGuardPolicy(statement);
            PreparedStatement preparedStatement = statement;
            return preparedStatement;
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    public void executeReleasePrepareStatement(PreparedStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("statement must no be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("executePrepareStatement", statement.mSql, statement.mBindArgs);
        try {
            this.releasePreparedStatement(statement);
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    private PreparedStatement acquirePreparedStatement(String sql) {
        PreparedStatement statement = null;
        long statementPtr = SQLiteConnection.nativePrepareStatement(this.mConnectionPtr, sql);
        try {
            int numParameters = SQLiteConnection.nativeGetParameterCount(this.mConnectionPtr, statementPtr);
            int type = DatabaseUtils.getSqlStatementType(sql);
            boolean readOnly = SQLiteConnection.nativeIsReadOnly(this.mConnectionPtr, statementPtr);
            statement = this.obtainPreparedStatement(sql, statementPtr, numParameters, type, readOnly);
        }
        catch (RuntimeException ex) {
            if (statement == null) {
                SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statementPtr);
            }
            throw ex;
        }
        statement.mInUse = true;
        return statement;
    }

    private void releasePreparedStatement(PreparedStatement statement) {
        statement.mInUse = false;
        this.finalizePreparedStatement(statement);
    }

    private void finalizePreparedStatement(PreparedStatement statement) {
        SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statement.mStatementPtr);
        this.recyclePreparedStatement(statement);
    }

    private void attachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
            ++this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 1) {
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, true);
                cancellationSignal.setOnCancelListener(this);
            }
        }
    }

    private void detachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            assert (this.mCancellationSignalAttachCount > 0);
            --this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 0) {
                cancellationSignal.setOnCancelListener(null);
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, false);
            }
        }
    }

    @Override
    public void onCancel() {
        SQLiteConnection.nativeCancel(this.mConnectionPtr);
    }

    private void bindArguments(PreparedStatement statement, Object[] bindArgs) {
        int count;
        int n = count = bindArgs != null ? bindArgs.length : 0;
        if (count != statement.mNumParameters) {
            throw new SQLiteBindOrColumnIndexOutOfRangeException("Expected " + statement.mNumParameters + " bind arguments but " + count + " were provided.");
        }
        statement.mBindArgs = bindArgs;
        if (count == 0) {
            return;
        }
        long statementPtr = statement.mStatementPtr;
        block6: for (int i = 0; i < count; ++i) {
            Object arg = bindArgs[i];
            switch (DatabaseUtils.getTypeOfObject(arg)) {
                case 0: {
                    SQLiteConnection.nativeBindNull(this.mConnectionPtr, statementPtr, i + 1);
                    continue block6;
                }
                case 1: {
                    SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).longValue());
                    continue block6;
                }
                case 2: {
                    SQLiteConnection.nativeBindDouble(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).doubleValue());
                    continue block6;
                }
                case 4: {
                    SQLiteConnection.nativeBindBlob(this.mConnectionPtr, statementPtr, i + 1, (byte[])arg);
                    continue block6;
                }
                default: {
                    if (arg instanceof Boolean) {
                        SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, (Boolean)arg != false ? 1L : 0L);
                        continue block6;
                    }
                    SQLiteConnection.nativeBindString(this.mConnectionPtr, statementPtr, i + 1, arg.toString());
                }
            }
        }
    }

    private void throwIfStatementForbidden(PreparedStatement statement) {
        if (this.mOnlyAllowReadOnlyOperations && !statement.mReadOnly) {
            throw new SQLiteException("Cannot execute this statement because it might modify the database but the connection is read-only.");
        }
    }

    private void applyBlockGuardPolicy(PreparedStatement statement) {
    }

    public void dump(Printer printer, boolean verbose) {
        this.dumpUnsafe(printer, verbose);
    }

    void dumpUnsafe(Printer printer, boolean verbose) {
        printer.println("Connection #" + this.mConnectionId + ":");
        if (verbose) {
            printer.println("  connectionPtr: 0x" + Long.toHexString(this.mConnectionPtr));
        }
        printer.println("  isPrimaryConnection: " + this.mIsPrimaryConnection);
        printer.println("  onlyAllowReadOnlyOperations: " + this.mOnlyAllowReadOnlyOperations);
        this.mRecentOperations.dump(printer, verbose);
    }

    String describeCurrentOperationUnsafe() {
        return this.mRecentOperations.describeCurrentOperation();
    }

    void collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        int lookaside = SQLiteConnection.nativeGetDbLookaside(this.mConnectionPtr);
        long pageCount = 0L;
        long pageSize = 0L;
        try {
            pageCount = this.executeForLong("PRAGMA page_count;", null, null);
            pageSize = this.executeForLong("PRAGMA page_size;", null, null);
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
        dbStatsList.add(this.getMainDbStatsUnsafe(lookaside, pageCount, pageSize));
    }

    void collectDbStatsUnsafe(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        dbStatsList.add(this.getMainDbStatsUnsafe(0, 0L, 0L));
    }

    private SQLiteDebug.DbStats getMainDbStatsUnsafe(int lookaside, long pageCount, long pageSize) {
        String label = this.mConfiguration.path;
        if (!this.mIsPrimaryConnection) {
            label = label + " (" + this.mConnectionId + ")";
        }
        return new SQLiteDebug.DbStats(label, pageCount, pageSize, lookaside);
    }

    public String toString() {
        return "SQLiteConnection: " + this.mConfiguration.path + " (" + this.mConnectionId + ")";
    }

    private PreparedStatement obtainPreparedStatement(String sql, long statementPtr, int numParameters, int type, boolean readOnly) {
        PreparedStatement statement = this.mPreparedStatementPool;
        if (statement != null) {
            this.mPreparedStatementPool = statement.mPoolNext;
            statement.mPoolNext = null;
        } else {
            statement = new PreparedStatement();
        }
        statement.mSql = sql;
        statement.mStatementPtr = statementPtr;
        statement.mNumParameters = numParameters;
        statement.mType = type;
        statement.mReadOnly = readOnly;
        return statement;
    }

    private void recyclePreparedStatement(PreparedStatement statement) {
        statement.mSql = null;
        statement.mPoolNext = this.mPreparedStatementPool;
        this.mPreparedStatementPool = statement;
    }

    private static String trimSqlForDisplay(String sql) {
        return sql.replaceAll("[\\s]*\\n+[\\s]*", " ");
    }

    private static final class Operation {
        public long mStartTime;
        public long mEndTime;
        public String mKind;
        public String mSql;
        public ArrayList<Object> mBindArgs;
        public boolean mFinished;
        public Exception mException;
        public int mCookie;

        private Operation() {
        }

        public void describe(StringBuilder msg, boolean verbose) {
            msg.append(this.mKind);
            if (this.mFinished) {
                msg.append(" took ").append(this.mEndTime - this.mStartTime).append("ms");
            } else {
                msg.append(" started ").append(System.currentTimeMillis() - this.mStartTime).append("ms ago");
            }
            msg.append(" - ").append(this.getStatus());
            if (this.mSql != null) {
                msg.append(", sql=\"").append(SQLiteConnection.trimSqlForDisplay(this.mSql)).append("\"");
            }
            if (verbose && this.mBindArgs != null && this.mBindArgs.size() != 0) {
                msg.append(", bindArgs=[");
                int count = this.mBindArgs.size();
                for (int i = 0; i < count; ++i) {
                    Object arg = this.mBindArgs.get(i);
                    if (i != 0) {
                        msg.append(", ");
                    }
                    if (arg == null) {
                        msg.append("null");
                        continue;
                    }
                    if (arg instanceof byte[]) {
                        msg.append("<byte[]>");
                        continue;
                    }
                    if (arg instanceof String) {
                        msg.append("\"").append((String)arg).append("\"");
                        continue;
                    }
                    msg.append(arg);
                }
                msg.append("]");
            }
            if (this.mException != null) {
                msg.append(", exception=\"").append(this.mException.getMessage()).append("\"");
            }
        }

        private String getStatus() {
            if (!this.mFinished) {
                return "running";
            }
            return this.mException != null ? "failed" : "succeeded";
        }

        private String getFormattedStartTime() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.mStartTime));
        }
    }

    private static final class OperationLog {
        private static final int MAX_RECENT_OPERATIONS = 20;
        private static final int COOKIE_GENERATION_SHIFT = 8;
        private static final int COOKIE_INDEX_MASK = 255;
        private final Operation[] mOperations = new Operation[20];
        private int mIndex;
        private int mGeneration;

        private OperationLog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int beginOperation(String kind, String sql, Object[] bindArgs) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                int index = (this.mIndex + 1) % 20;
                Operation operation = this.mOperations[index];
                if (operation == null) {
                    this.mOperations[index] = operation = new Operation();
                } else {
                    operation.mFinished = false;
                    operation.mException = null;
                    if (operation.mBindArgs != null) {
                        operation.mBindArgs.clear();
                    }
                }
                operation.mStartTime = System.currentTimeMillis();
                operation.mKind = kind;
                operation.mSql = sql;
                if (bindArgs != null) {
                    if (operation.mBindArgs == null) {
                        operation.mBindArgs = new ArrayList();
                    } else {
                        operation.mBindArgs.clear();
                    }
                    for (int i = 0; i < bindArgs.length; ++i) {
                        Object arg = bindArgs[i];
                        if (arg != null && arg instanceof byte[]) {
                            operation.mBindArgs.add(EMPTY_BYTE_ARRAY);
                            continue;
                        }
                        operation.mBindArgs.add(arg);
                    }
                }
                operation.mCookie = this.newOperationCookieLocked(index);
                this.mIndex = index;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return operation.mCookie;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failOperation(int cookie, Exception ex) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.getOperationLocked(cookie);
                if (operation != null) {
                    operation.mException = ex;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endOperation(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                if (this.endOperationDeferLogLocked(cookie)) {
                    this.logOperationLocked(cookie, null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean endOperationDeferLog(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.endOperationDeferLogLocked(cookie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logOperation(int cookie, String detail) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                this.logOperationLocked(cookie, detail);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private boolean endOperationDeferLogLocked(int cookie) {
            Operation operation = this.getOperationLocked(cookie);
            if (operation != null) {
                operation.mEndTime = System.currentTimeMillis();
                operation.mFinished = true;
                return false;
            }
            return false;
        }

        private void logOperationLocked(int cookie, String detail) {
            Operation operation = this.getOperationLocked(cookie);
            StringBuilder msg = new StringBuilder();
            operation.describe(msg, false);
            if (detail != null) {
                msg.append(", ").append(detail);
            }
            DLog.d(SQLiteConnection.TAG, msg.toString());
        }

        private int newOperationCookieLocked(int index) {
            int generation = this.mGeneration++;
            return generation << 8 | index;
        }

        private Operation getOperationLocked(int cookie) {
            int index = cookie & 0xFF;
            Operation operation = this.mOperations[index];
            return operation.mCookie == cookie ? operation : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String describeCurrentOperation() {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.mOperations[this.mIndex];
                if (operation != null && !operation.mFinished) {
                    StringBuilder msg = new StringBuilder();
                    operation.describe(msg, false);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return msg.toString();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(Printer printer, boolean verbose) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                printer.println("  Most recently executed operations:");
                int index = this.mIndex;
                Operation operation = this.mOperations[index];
                if (operation != null) {
                    int n = 0;
                    do {
                        StringBuilder msg = new StringBuilder();
                        msg.append("    ").append(n).append(": [");
                        msg.append(operation.getFormattedStartTime());
                        msg.append("] ");
                        operation.describe(msg, verbose);
                        printer.println(msg.toString());
                        if (index > 0) {
                            --index;
                            continue;
                        }
                        index = 19;
                    } while ((operation = this.mOperations[index]) != null && ++n < 20);
                } else {
                    printer.println("    <none>");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    protected static final class PreparedStatement {
        public PreparedStatement mPoolNext;
        public String mSql;
        public Object[] mBindArgs;
        public long mStatementPtr;
        public int mNumParameters;
        public int mType;
        public boolean mReadOnly;
        public boolean mInUse;

        protected PreparedStatement() {
        }
    }
}

