/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.log;

import com.couchbase.lite.internal.database.log.Logger;
import com.couchbase.lite.internal.database.log.SystemLogger;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class DLog {
    public static Logger logger = new SystemLogger();
    private static ConcurrentHashMap<String, Integer> enabledTags = new ConcurrentHashMap();
    public static final String TAG_SQLiteConnection = "SQLiteConnection";
    public static final String TAG_SQLiteConnectionPool = "SQLiteConnectionPool";
    public static final String TAG_SQLiteDatabase = "SQLiteDatabase";
    public static final String TAG_SQLiteQueryBuilder = "SQLiteQueryBuilder";
    public static final String TAG_SQLiteQueryCursor = "SQLiteQueryCursor";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    public static void enableLogging(String tag, int logLevel) {
        enabledTags.put(tag, logLevel);
    }

    static boolean isLoggingEnabled(String tag, int logLevel) {
        Integer logLevelForTag = enabledTags.get(tag);
        return logLevel >= (logLevelForTag == null ? 4 : logLevelForTag);
    }

    public static void v(String tag, String msg) {
        if (logger != null && DLog.isLoggingEnabled(tag, 2)) {
            logger.v(tag, msg);
        }
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 2)) {
            logger.v(tag, msg, tr);
        }
    }

    public static void v(String tag, String formatString, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 2)) {
            try {
                logger.v(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.v(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void v(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 2)) {
            try {
                logger.v(tag, String.format(Locale.ENGLISH, formatString, args), tr);
            }
            catch (Exception e) {
                logger.v(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void d(String tag, String msg) {
        if (logger != null && DLog.isLoggingEnabled(tag, 3)) {
            logger.d(tag, msg);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 3)) {
            logger.d(tag, msg, tr);
        }
    }

    public static void d(String tag, String formatString, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 3)) {
            try {
                logger.d(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.d(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void d(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 3)) {
            try {
                logger.d(tag, String.format(Locale.ENGLISH, formatString, args, tr));
            }
            catch (Exception e) {
                logger.d(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void i(String tag, String msg) {
        if (logger != null && DLog.isLoggingEnabled(tag, 4)) {
            logger.i(tag, msg);
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 4)) {
            logger.i(tag, msg, tr);
        }
    }

    public static void i(String tag, String formatString, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 4)) {
            try {
                logger.i(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.i(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void i(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 4)) {
            try {
                logger.i(tag, String.format(Locale.ENGLISH, formatString, args, tr));
            }
            catch (Exception e) {
                logger.i(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void w(String tag, String msg) {
        if (logger != null && DLog.isLoggingEnabled(tag, 5)) {
            logger.w(tag, msg);
        }
    }

    public static void w(String tag, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 5)) {
            logger.w(tag, tr);
        }
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 5)) {
            logger.w(tag, msg, tr);
        }
    }

    public static void w(String tag, String formatString, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 5)) {
            try {
                logger.w(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.w(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void w(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 5)) {
            try {
                logger.w(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.w(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void e(String tag, String msg) {
        if (logger != null && DLog.isLoggingEnabled(tag, 6)) {
            logger.e(tag, msg);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (logger != null && DLog.isLoggingEnabled(tag, 6)) {
            logger.e(tag, msg, tr);
        }
    }

    public static void e(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 6)) {
            try {
                logger.e(tag, String.format(Locale.ENGLISH, formatString, args), tr);
            }
            catch (Exception e) {
                logger.e(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void e(String tag, String formatString, Object ... args) {
        if (logger != null && DLog.isLoggingEnabled(tag, 6)) {
            try {
                logger.e(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.e(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    static {
        enabledTags.put(TAG_SQLiteConnection, 5);
        enabledTags.put(TAG_SQLiteConnectionPool, 5);
        enabledTags.put(TAG_SQLiteDatabase, 5);
        enabledTags.put(TAG_SQLiteQueryBuilder, 5);
        enabledTags.put(TAG_SQLiteQueryCursor, 5);
    }
}

