/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import com.couchbase.lite.internal.Body;
import com.couchbase.lite.util.CollectionUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class RevisionInternal {
    private String docID;
    private String revID;
    private boolean deleted;
    private boolean missing;
    private Body body;
    private long sequence;

    public RevisionInternal(String docID, String revID, boolean deleted) {
        this.docID = docID;
        this.revID = revID;
        this.deleted = deleted;
    }

    public RevisionInternal(Body body) {
        this((String)body.getPropertyForKey("_id"), (String)body.getPropertyForKey("_rev"), body.getPropertyForKey("_deleted") != null && (Boolean)body.getPropertyForKey("_deleted") == true);
        this.body = body;
    }

    public RevisionInternal(Map<String, Object> properties) {
        this(new Body(properties));
    }

    public RevisionInternal(Map<String, Object> properties, long size) {
        this(new Body(properties, size));
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public String getRevID() {
        return this.revID;
    }

    public void setRevID(String revID) {
        this.revID = revID;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof RevisionInternal) {
            RevisionInternal other = (RevisionInternal)o;
            if (this.docID.equals(other.docID) && this.revID.equals(other.revID)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.docID.hashCode() ^ this.revID.hashCode();
    }

    public String toString() {
        return '{' + this.docID + " #" + this.revID + " @" + this.sequence + (this.deleted ? " DEL" : "") + '}';
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = null;
        if (this.body != null) {
            Map<String, Object> prop;
            try {
                prop = this.body.getProperties();
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            result.putAll(prop);
        }
        return result;
    }

    public Object getPropertyForKey(String key) {
        Map<String, Object> prop = this.getProperties();
        if (prop == null) {
            return null;
        }
        return prop.get(key);
    }

    public void setProperties(Map<String, Object> properties) {
        this.body = new Body(properties);
    }

    public byte[] getJson() {
        byte[] result = null;
        if (this.body != null) {
            result = this.body.getJson();
        }
        return result;
    }

    public void setJSON(byte[] json) {
        this.body = new Body(json, this.docID, this.revID, this.deleted);
    }

    public RevisionInternal copy() {
        return this.copyWithDocID(this.docID, this.revID);
    }

    public RevisionInternal copyWithDocID(String docID, String revID) {
        assert (docID != null);
        assert (this.docID == null || this.docID.equals(docID));
        RevisionInternal rev = new RevisionInternal(docID, revID, this.deleted);
        Map<String, Object> unmodifiableProperties = this.getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (unmodifiableProperties != null) {
            properties.putAll(unmodifiableProperties);
        }
        properties.put("_id", docID);
        properties.put("_rev", revID);
        rev.setProperties(properties);
        return rev;
    }

    public RevisionInternal copyWithoutBody() {
        if (this.body == null) {
            return this;
        }
        RevisionInternal rev = new RevisionInternal(this.docID, this.revID, this.deleted);
        rev.setSequence(this.sequence);
        rev.setMissing(this.missing);
        return rev;
    }

    public int getGeneration() {
        return RevisionInternal.generationFromRevID(this.revID);
    }

    public boolean mutateAttachments(CollectionUtils.Functor<Map<String, Object>, Map<String, Object>> functor) {
        Map<String, Object> properties = this.getProperties();
        HashMap<String, Object> editedProperties = null;
        Map attachments = (Map)properties.get("_attachments");
        HashMap<String, Map<String, Object>> editedAttachments = null;
        if (attachments != null) {
            for (String name : attachments.keySet()) {
                HashMap<String, String> attachment = new HashMap<String, String>((Map)attachments.get(name));
                attachment.put("name", name);
                Map<String, Object> editedAttachment = functor.invoke(attachment);
                if (editedAttachment == null) {
                    return false;
                }
                if (editedAttachment == attachment) continue;
                if (editedProperties == null) {
                    editedProperties = new HashMap<String, Object>(properties);
                    editedAttachments = new HashMap<String, Map<String, Object>>(attachments);
                    editedProperties.put("_attachments", editedAttachments);
                }
                editedAttachment.remove("name");
                editedAttachments.put(name, editedAttachment);
            }
        }
        if (editedProperties != null) {
            this.setProperties(editedProperties);
            return true;
        }
        return false;
    }

    public Map<String, Object> getAttachments() {
        Map<String, Object> props = this.getProperties();
        if (props != null && props.containsKey("_attachments")) {
            return (Map)props.get("_attachments");
        }
        return null;
    }

    public Object getObject(String key) {
        return this.body != null ? this.body.getObject(key) : null;
    }

    public static int generationFromRevID(String revID) {
        if (revID == null) {
            return 0;
        }
        int generation = 0;
        int dashPos = revID.indexOf(45);
        if (dashPos > 0) {
            generation = Integer.parseInt(revID.substring(0, dashPos));
        }
        return generation;
    }

    public static String digestFromRevID(String revID) {
        String digest = "error";
        int dashPos = revID.indexOf(45);
        if (dashPos > 0) {
            digest = revID.substring(dashPos + 1);
            return digest;
        }
        throw new RuntimeException(String.format(Locale.ENGLISH, "Invalid rev id: %s", revID));
    }

    public static int CBLCollateRevIDs(String revId1, String revId2) {
        Integer rev2Generation;
        Integer rev1Generation;
        String rev1GenerationStr = null;
        String rev2GenerationStr = null;
        String rev1Hash = null;
        String rev2Hash = null;
        StringTokenizer st1 = new StringTokenizer(revId1, "-");
        try {
            rev1GenerationStr = st1.nextToken();
            rev1Hash = st1.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringTokenizer st2 = new StringTokenizer(revId2, "-");
        try {
            rev2GenerationStr = st2.nextToken();
            rev2Hash = st2.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rev1GenerationStr == null || rev2GenerationStr == null) {
            return revId1.compareToIgnoreCase(revId2);
        }
        try {
            rev1Generation = Integer.parseInt(rev1GenerationStr);
            rev2Generation = Integer.parseInt(rev2GenerationStr);
        }
        catch (NumberFormatException e) {
            return revId1.compareToIgnoreCase(revId2);
        }
        if (rev1Generation.compareTo(rev2Generation) != 0) {
            return rev1Generation.compareTo(rev2Generation);
        }
        if (rev1Hash != null && rev2Hash != null) {
            return rev1Hash.compareTo(rev2Hash);
        }
        return revId1.compareToIgnoreCase(revId2);
    }

    public static int CBLCompareRevIDs(String revId1, String revId2) {
        assert (revId1 != null);
        assert (revId2 != null);
        return RevisionInternal.CBLCollateRevIDs(revId1, revId2);
    }
}

